#!/usr/bin/perl

$philos=$ARGV[0];

print "PLACE ";
# places for the philosophers
for($p = 1; $p <= $philos; $p++) {
    print "p",$p,"_thinking,";
    print "p",$p,"_withleft,";
    print "p",$p,"_eating,";
}
# places for the forks
for($p = 1; $p <= $philos; $p++) {
    print "f",$p;
    if($p != $philos) {print ",";}
}
print ";\n";

# initial marking
print "MARKING ";
for($p = 1; $p <= $philos; $p++) {
    print "p",$p,"_thinking:1,";
    print "f",$p,":1";
    if($p < $philos) {print ",";}
}
print ";\n\n";

#transitions
for($p = 1; $p <= $philos; $p++) {
    print "TRANSITION t",$p,"_takeleft\n";
    print "CONSUME p",$p,"_thinking:1,f",$p,":1;\n";
    print "PRODUCE p",$p,"_withleft:1;\n";
}
for($p = 1; $p <= $philos; $p++) {
    print "TRANSITION t",$p,"_takeright\n";
    print "CONSUME p",$p,"_withleft:1,f",($p % $philos)+1,":1;\n";
    print "PRODUCE p",$p,"_eating:1;\n";
}
for($p = 1; $p <= $philos; $p++) {
    print "TRANSITION t",$p,"_stopeating\n";
    print "CONSUME p",$p,"_eating:1;\n";
    print "PRODUCE p",$p,"_thinking:1,f",$p,":1,f",($p % $philos)+1,":1;\n";
}

