#include <stdint.h>

#define CHARTYPE unsigned char
#define MAXPAT 51000
#define LIM 65536
#define W 64
#define Q 2

typedef uint64_t bv;

bv pre, B[LIM];
CHARTYPE pattern[MAXPAT];
int patlen, a, b;

void prep(const CHARTYPE *pat, register int m) {
    int i, j, r, x, y;

    memcpy(pattern, pat, m);
    patlen = m;
    pre = *((uint64_t*) (pat));

    for (i=0; i<LIM; i++) B[i]=0;

    x=0; if (m<=4096) x=1;
    a=(m-Q+1-x)/W+x; 
    r=(m-Q+1)/a; 
    if (r>W) r=W;
    y=W-r;
    b=r*a;

    i=m-Q;
    while (i>m-b-Q) { 
       for (j=1; j<=a; j++) {
          B[*((uint16_t*)(pattern+i))] |= (bv)1 << y;
          i--;  
       }
       y++;
    }
}

int exec(CHARTYPE *t, register int n) {

    bv d;
    int i, j, k, m = patlen, count = 0;
 
    i = m-1;
    t[n] = 0;

   while (i<n) {
      d = B[*((uint16_t*)(t+i-1))]; 
      if (d==0) i+=b;
      else {
         j = i;
         do {i-=a; 
            d=(d<<1)&B[*((uint16_t*)(t+i-1))];}
         while (d);
         i += b; 
         if (i==j) {
            for (k=0; k<a; k++) 
               if(pre == *((uint64_t*) (t+i-m+1+k)))
                  if(memcmp(t+i-m+1+k,pattern,m) == 0) 
                     count++;
            i+=a;
         }
      }
    }
return count;
}

