static unsigned char mask[MAXPAT * ALPHA];
static unsigned int pi[MAXPAT];

#define PI(a)(pi[(a)])

void prep(unsigned char * pat, size_t patlen, size_t k) 
{
   P = pat;
   m = patlen;
   (void) k;
   int i, j;

   static int rank[] = {
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      22, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63,  0, 56, 63, 63, 63, 63, 63, 46, 
      58, 59, 63, 63, 15, 61, 24, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 28, 29, 
      63, 63, 63, 39, 63, 26, 38, 50, 32, 42, 
      45, 35, 40, 27, 36, 55, 30, 41, 48, 31, 
      49, 62, 34, 37, 33, 57, 60, 44, 63, 54, 
      53, 63, 63, 63, 63, 63, 63,  4, 20, 18, //        abc
      10,  1, 13, 19,  3,  8, 43, 25, 11, 14, // defghijklm
       6,  5, 21, 52,  9,  7,  2, 12, 23, 16, // nopqrstuvw
      51, 17, 47, 63, 63, 63, 63, 63, 63, 63, // xyz 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
      63, 63, 63, 63, 63, 63};

   for (j = 0; j < m; j++)
      for (i = 0; i < ALPHA; i++)
         mask[j * ALPHA + i] = P[j];

   for (i = 0; i < m; i++) {
      int j = i;
      while (j > 0 && rank[P[pi[j - 1]]] < rank[P[i]]) {
         pi[j] = pi[j - 1];
         j--;
      }
      pi[j] = i;
   }
}
