#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <xmmintrin.h>
#include <immintrin.h>
#include <x86intrin.h>
#include <limits.h>

#define ASIZE (UCHAR_MAX + 1)
#define MAXPAT 100

#if ALPHA == 16
#define LOG_ALPHA 4
#define loadu_si _mm_loadu_si128
#define cmpeq_yx _mm_movemask_epi8(_mm_cmpeq_epi8(y_ptr,x_ptr))
#define popcnt _popcnt32
#define mi __m128i
#define ui uint16_t
#endif

#if ALPHA == 32
#define LOG_ALPHA 5
#define loadu_si _mm256_loadu_si256
#define cmpeq_yx _mm256_movemask_epi8(_mm256_cmpeq_epi8(y_ptr,x_ptr))
#define popcnt _mm_popcnt_u32
#define mi __m256i
#define ui uint32_t
#endif

#if ALPHA == 64
#define LOG_ALPHA 6
#define loadu_si  _mm512_loadu_si512
#define cmpeq_yx _mm512_cmpeq_epi8_mask(y_ptr,x_ptr)
#define popcnt _mm_popcnt_u64
#define mi __m512i
#define ui uint64_t
#endif

#define load_y y_ptr = loadu_si(( mi *)(T + id))
#define load_x x_ptr = loadu_si(( mi *)(mask + (id << LOG_ALPHA)))

static unsigned char *P;
static size_t m;

#define PLAIN 1
#define FIXED 2
#define EGLISH 3

#if ORDER == PLAIN
#include "plain.h"
#endif

#if ORDER == FIXED
#include "fixed.h"
#endif

#if ORDER == ENGLISH
#include "english.h"
#endif


