/**
 * 3 Band EQ VST Plugin
 *
 * Copyright (C) 2010 Simo Srkk (STS)
 *
 * $Id: sts3bandeq_vst.h,v 1.3 2010/01/04 22:01:31 ssarkka Exp $
 */

#ifndef __sts3bandeq_vst__
#define __sts3bandeq_vst__

#include "public.sdk/source/vst2.x/audioeffectx.h"
#include "sts3bandeq_core.h"

#include <cstdio>
#include <cmath>

enum {
    EQP_LF_Q = 0,
    EQP_LF_F,
    EQP_LF_DB,
    EQP_LMF_Q,
    EQP_LMF_F,
    EQP_LMF_DB,
    EQP_MF_Q,
    EQP_MF_F,
    EQP_MF_DB,
    EQP_HMF_Q,
    EQP_HMF_F,
    EQP_HMF_DB,
    EQP_HF_Q,
    EQP_HF_F,
    EQP_HF_DB,
};

class Sts3BandEQ_VST : public AudioEffectX
{
public:
	Sts3BandEQ_VST (audioMasterCallback audioMaster);
	~Sts3BandEQ_VST ();

	// Processing
	virtual void processReplacing (float** inputs,
				       float** outputs,
				       VstInt32 sampleFrames);

	virtual void processDoubleReplacing (double** inputs,
					     double** outputs,
					     VstInt32 sampleFrames);

	// Program
	virtual void setProgramName (char* name);
	virtual void getProgramName (char* name);

	// Parameters
	virtual void setParameter (VstInt32 index, float value);
	virtual float getParameter (VstInt32 index);
	virtual void getParameterLabel (VstInt32 index, char* label);
	virtual void getParameterDisplay (VstInt32 index, char* text);
	virtual void getParameterName (VstInt32 index, char* text);

	virtual bool getEffectName (char* name);
	virtual bool getVendorString (char* text);
	virtual bool getProductString (char* text);
	virtual VstInt32 getVendorVersion ();

protected:
	Sts3BandEQ m_eq1, m_eq2;
	char programName[kVstMaxProgNameLen + 1];
};

#endif
