%EQF_EXPM  Transition matrix of EQ filter
%
% Syntax:
%   A = eqf_expm(a1,a2,w0,T)
%
% In:
%   a1 - Numerator coefficient
%   a2 - Numerator coefficient
%   w0 - Angular velocity
%   T  - Sampling period
%
% Out:
%   A = expm(T*w0*[-a1 1; -a2 0])
%
% Description:
%   Closed form solution of transition matrix
%   for equalizer filters.

function A = eqf_expm(a1,a2,w0,T)

  d = a1^2 - 4*a2;
  if d < 0
    d = sqrt(-d);
    si = sin(d*w0*T/2);
    co = cos(d*w0*T/2);  
  else
    d = sqrt(d);
    si = sinh(d*w0*T/2);
    co = cosh(d*w0*T/2);    
  end

  ep = exp(-a1*w0*T/2);
  ex11 = ep*co - a1/d*ep*si;
  ex12 = 2/d*ep*si;
  ex21 = -2*a2/d*ep*si;
  ex22 = ep*co + a1/d*ep*si;
  A = [ex11 ex12; ex21 ex22];
  
