%EQF_DISC  Discretize given equalizer filter
%
% Syntax:
%   [A,BL] = eqf_disc(a1,a2,b1,b2,w0,T,n,int_n)
%
% In:
%   a1 - Numerator coefficient
%   a2 - Numerator coefficient
%   b1 - Denominator coefficient
%   b2 - Denominator coefficient
%   w0 - Angular velocity
%   T  - Sampling period
%   n  - Order of input approximation
%   int_n - Simpson's rule integration steps (default 10)
%
% Out:
%   A  - Transition matrix
%   BL - 2x(2n+1) matrix of 2x1 input matrices

function [A,BL] = eqf_disc(a1,a2,b1,b2,w0,T,n,int_n)

  if nargin < 8
      int_n = [];
  end
  
  if isempty(int_n)
      int_n = 10;
  end

  % Integrate Bj's with Simpson's rule
  h = T/int_n;
  BL = zeros(2,2*n+1);
  i = 1;
  for j=-n:n
      B = eqf_integrand(0,a1,a2,b1,b2,w0,T,j,n);
      for k=1:int_n-1
          if rem(k,2) == 1
              B = B + 4*eqf_integrand(k*h,a1,a2,b1,b2,w0,T,j,n);
          else
              B = B + 2*eqf_integrand(k*h,a1,a2,b1,b2,w0,T,j,n);
          end
      end
      B = B + eqf_integrand(T,a1,a2,b1,b2,w0,T,j,n);
      B = h/3*B;

      BL(:,i) = B;
      i = i + 1;
  end
  
  % Transition matrix
  A = eqf_expm(a1,a2,w0,T);

  
 