(* Hash functions *)

fun rot31 w =
    let	val uppers = Word32.>>(w,0w24)
	val lower = Word32.andb(0wx00ffffff,w)
    in
	Word32.xorb(lower*0w31,uppers)
    end

fun stringhash0 (s,i,sz,ac) = if i=sz
			      then ac
			      else stringhash0(s,i+1,sz,
					       Word32.xorb(rot31 ac,
							   Word32.fromInt(ord (String.sub(s,i)))));
fun stringhash1 s = stringhash0(s,0,String.size s,0w0);
fun stringhash s = Word32.toInt(stringhash1 s);

fun stringlisthash1 ss = revfold (fn (s,i) => Word32.xorb(rot31 i,stringhash1 s)) ss 0w0;
fun stringlisthash ss = Word32.toInt(stringlisthash1 ss);
