
(* 2011-17 (C) Jussi Rintanen *)

fun listwithoutlast [] = []
  | listwithoutlast [_] = []
  | listwithoutlast (e::es) = e::(listwithoutlast es);

fun apphd f [] = f []
  | apphd f (l as (e::es)) = (f l; apphd f es);

fun apppairs f (e1::e2::es) = (f(e1,e2);apppairs f (e2::es))
  | apppairs f _ = ();

fun fold f [] b = b (* same as List.foldr *)
  | fold f (h::t) b = f(h,fold f t b);

fun revfold f [] b = b (* same as List.foldl *)
  | revfold f (h::t) b = revfold f t (f(h,b));

(*
fun fold f ls b = List.foldr f b ls;
fun revfold f ls b = List.foldl f b ls;
*)

(* Go through air pairs of a cartesian product *)

fun foldp' f (e,[],ac) = ac
  | foldp' f (e,e'::es,ac) = foldp' f (e,es,f(e,e',ac));
fun foldp f ([],s2) ac = ac
  | foldp f (e::es,s2) ac = foldp f (es,s2) (foldp' f (e,s2,ac));

fun member(a,[]) = false
  | member(a,h::t) = a=h orelse member(a,t);

fun realmember(a,[]) = false
  | realmember(a,h::t) = Real.==(a,h) orelse realmember(a,t);

fun intersect ([],l) = false
  | intersect (h::t,l) = member(h,l) orelse intersect(t,l);

fun intersection ([],l) = []
  | intersection (e::es,l) = if member(e,l) then e::(intersection(es,l))
			     else intersection(es,l);
    
fun intersectl [] = []
  | intersectl (s::ss) = revfold intersection ss s;

fun add (a,ac) = if member(a,ac) then ac else a::ac;
fun realadd (a,ac) = if realmember(a,ac) then ac else a::ac;

fun union([],l) = l
  | union(h::t,l) = if member(h,l) then union (t,l) else h::union(t,l);

fun unionl [] = []
  | unionl (l::ls) = union(l,unionl ls);

fun concat ls = fold (op @) ls [];

fun subset([],_) = true
  | subset(h::t,l) = member(h,l) andalso subset(t,l);

fun sameset (s1,s2) = subset(s1,s2) andalso subset(s2,s1);

fun difference ([],_) = []
  | difference (e::es,l) = if member (e,l)
			     then difference (es,l)
			   else e::(difference (es,l));

fun emptyp [] = true
  | emptyp _ = false;

fun filter p [] = []
  | filter p (e::es) = if (p e) then e::(filter p es) else (filter p es);

fun filter2 p [] = ([],[])
  | filter2 p (e::es) =
    let val (l1,l2) = filter2 p es
    in
      if (p e) then (e::l1,l2) else (l1,e::l2)
    end;

exception Pick;
fun pick p [] = raise Pick
  | pick p (e::es) = if (p e) then e else pick p es;

fun forall p [] = true
  | forall p (e::es) = (p e) andalso forall p es;

fun forsome p [] = false
  | forsome p (e::es) = (p e) orelse forsome p es;

fun forallpairs p ([],_) = true
  | forallpairs p (_,[]) = true
  | forallpairs p (e1::es,es2) = forall (fn e2 => p(e1,e2)) es2
				 andalso forallpairs p (es,es2)

fun forsomepair p ([],_) = false
  | forsomepair p (_,[]) = false
  | forsomepair p (e1::es,es2) = forsome (fn e2 => p(e1,e2)) es2
				 orelse forsomepair p (es,es2)

val exists = forsome;

fun product (a,b) = fold (fn (a,s) => fold (fn (b,s) => (a,b)::s) b s) a [];

fun productl [] = [[]]
  | productl (es::ls) =
    let val p = productl ls
    in
      fold (fn (e,ac) => (map (fn l => e::l) p)@ac) es []
    end;

(* For a list [1,2,...,n], all pairs (1,2), (1,3), ..., (1,n), (2,3), ... *)

fun lproduct [] = []
  | lproduct (n::ns) = fold (fn (n',ac) => (n,n')::ac) ns (lproduct ns);

fun noduplicates [] = []
  | noduplicates (e::es) = if member(e,es) then noduplicates es
			   else e::(noduplicates es);

(* Association lists *)

fun assigned(s,[]) = false
  | assigned(s,(k,n)::ls) = s = k orelse assigned(s,ls);

fun rassigned(s,[]) = false
  | rassigned(s,(n,k)::ls) = s = k orelse rassigned(s,ls);

fun assoc (s,(k,e)::al) = if s = k then e else assoc(s,al);
(*   | assoc _ = (print "assoc failed.\n";raise Match) *)
fun rassoc (s,(e,k)::al) = if s = k then e else rassoc(s,al)
  | rassoc _ = (print "rassoc failed.\n";raise Match)

fun SNassoc (s,(k,e)::al) = if s = k then SOME e else SNassoc(s,al)
  | SNassoc (s,[]) = NONE;

(* Projection functions *)

fun p12 (a,_) = a;
fun p22 (_,a) = a;

fun p13 (a,_,_) = a;
fun p23 (_,a,_) = a;
fun p33 (_,_,a) = a;

fun p14 (a,_,_,_) = a;
fun p24 (_,a,_,_) = a;
fun p34 (_,_,a,_) = a;
fun p44 (_,_,_,a) = a;

fun p15 (a,_,_,_,_) = a;
fun p25 (_,a,_,_,_) = a;
fun p35 (_,_,a,_,_) = a;
fun p45 (_,_,_,a,_) = a;
fun p55 (_,_,_,_,a) = a;

fun p16 (a,_,_,_,_,_) = a;
fun p26 (_,a,_,_,_,_) = a;
fun p36 (_,_,a,_,_,_) = a;
fun p46 (_,_,_,a,_,_) = a;
fun p56 (_,_,_,_,a,_) = a;
fun p66 (_,_,_,_,_,a) = a;

fun p17 (a,_,_,_,_,_,_) = a;
fun p27 (_,a,_,_,_,_,_) = a;
fun p37 (_,_,a,_,_,_,_) = a;
fun p47 (_,_,_,a,_,_,_) = a;
fun p57 (_,_,_,_,a,_,_) = a;
fun p67 (_,_,_,_,_,a,_) = a;
fun p77 (_,_,_,_,_,_,a) = a;


fun p18 (a,_,_,_,_,_,_,_) = a;
fun p28 (_,a,_,_,_,_,_,_) = a;
fun p38 (_,_,a,_,_,_,_,_) = a;
fun p48 (_,_,_,a,_,_,_,_) = a;
fun p58 (_,_,_,_,a,_,_,_) = a;
fun p68 (_,_,_,_,_,a,_,_) = a;
fun p78 (_,_,_,_,_,_,a,_) = a;
fun p88 (_,_,_,_,_,_,_,a) = a;

fun p19 (a,_,_,_,_,_,_,_,_) = a;
fun p29 (_,a,_,_,_,_,_,_,_) = a;
fun p39 (_,_,a,_,_,_,_,_,_) = a;
fun p49 (_,_,_,a,_,_,_,_,_) = a;
fun p59 (_,_,_,_,a,_,_,_,_) = a;
fun p69 (_,_,_,_,_,a,_,_,_) = a;
fun p79 (_,_,_,_,_,_,a,_,_) = a;
fun p89 (_,_,_,_,_,_,_,a,_) = a;
fun p99 (_,_,_,_,_,_,_,_,a) = a;

fun p1A (a,_,_,_,_,_,_,_,_,_) = a;
fun p2A (_,a,_,_,_,_,_,_,_,_) = a;
fun p3A (_,_,a,_,_,_,_,_,_,_) = a;
fun p4A (_,_,_,a,_,_,_,_,_,_) = a;
fun p5A (_,_,_,_,a,_,_,_,_,_) = a;
fun p6A (_,_,_,_,_,a,_,_,_,_) = a;
fun p7A (_,_,_,_,_,_,a,_,_,_) = a;
fun p8A (_,_,_,_,_,_,_,a,_,_) = a;
fun p9A (_,_,_,_,_,_,_,_,a,_) = a;
fun pAA (_,_,_,_,_,_,_,_,_,a) = a;

fun p1B (a,_,_,_,_,_,_,_,_,_,_) = a;
fun p2B (_,a,_,_,_,_,_,_,_,_,_) = a;
fun p3B (_,_,a,_,_,_,_,_,_,_,_) = a;
fun p4B (_,_,_,a,_,_,_,_,_,_,_) = a;
fun p5B (_,_,_,_,a,_,_,_,_,_,_) = a;
fun p6B (_,_,_,_,_,a,_,_,_,_,_) = a;
fun p7B (_,_,_,_,_,_,a,_,_,_,_) = a;
fun p8B (_,_,_,_,_,_,_,a,_,_,_) = a;
fun p9B (_,_,_,_,_,_,_,_,a,_,_) = a;
fun pAB (_,_,_,_,_,_,_,_,_,a,_) = a;
fun pBB (_,_,_,_,_,_,_,_,_,_,a) = a;

fun p1C (a,_,_,_,_,_,_,_,_,_,_,_) = a;
fun p2C (_,a,_,_,_,_,_,_,_,_,_,_) = a;
fun p3C (_,_,a,_,_,_,_,_,_,_,_,_) = a;
fun p4C (_,_,_,a,_,_,_,_,_,_,_,_) = a;
fun p5C (_,_,_,_,a,_,_,_,_,_,_,_) = a;
fun p6C (_,_,_,_,_,a,_,_,_,_,_,_) = a;
fun p7C (_,_,_,_,_,_,a,_,_,_,_,_) = a;
fun p8C (_,_,_,_,_,_,_,a,_,_,_,_) = a;
fun p9C (_,_,_,_,_,_,_,_,a,_,_,_) = a;
fun pAC (_,_,_,_,_,_,_,_,_,a,_,_) = a;
fun pBC (_,_,_,_,_,_,_,_,_,_,a,_) = a;
fun pCC (_,_,_,_,_,_,_,_,_,_,_,a) = a;

fun p1D (a,_,_,_,_,_,_,_,_,_,_,_,_) = a;
fun p2D (_,a,_,_,_,_,_,_,_,_,_,_,_) = a;
fun p3D (_,_,a,_,_,_,_,_,_,_,_,_,_) = a;
fun p4D (_,_,_,a,_,_,_,_,_,_,_,_,_) = a;
fun p5D (_,_,_,_,a,_,_,_,_,_,_,_,_) = a;
fun p6D (_,_,_,_,_,a,_,_,_,_,_,_,_) = a;
fun p7D (_,_,_,_,_,_,a,_,_,_,_,_,_) = a;
fun p8D (_,_,_,_,_,_,_,a,_,_,_,_,_) = a;
fun p9D (_,_,_,_,_,_,_,_,a,_,_,_,_) = a;
fun pAD (_,_,_,_,_,_,_,_,_,a,_,_,_) = a;
fun pBD (_,_,_,_,_,_,_,_,_,_,a,_,_) = a;
fun pCD (_,_,_,_,_,_,_,_,_,_,_,a,_) = a;
fun pDD (_,_,_,_,_,_,_,_,_,_,_,_,a) = a;

(* Project with one element eliminated *)

fun i14 (_,a,b,c) = (a,b,c);

fun listlen [] = 0
  | listlen (_::t) = 1+(listlen t);

fun fromto(b,e) = if b > e then [] else b::(fromto(b+1,e));
fun fromtostep(b,e,s) = if b > e then [] else b::(fromtostep(b+s,e,s));

(* Attach a unique integer to each element of a list. *)

fun number ([],n) = []
  | number (h::t,n) = (n,h)::(number(t,n+1));

fun number2 ([],ac,n) = (ac,n)
  | number2 (h::t,ac,n) = number2(t,(n,h)::ac,n+1);

(* First list is longer than the second. *)
fun longer([],_) = false
  | longer(_,[]) = true
  | longer(_::l1,_::l2) = longer(l1,l2);

fun implies(a,b) = not a orelse b;

fun app2 f [] [] = ()
  | app2 f (e::es) (g::gs) = (f(e,g);app2 f es gs)
  | app2 f _ _ = (print "app2 failed\n";raise Match)

fun map2 f [] [] = []
  | map2 f (e::es) (g::gs) = (f(e,g))::(map2 f es gs)
  | map2 _ _ _ = (print "map2 failed.\n";raise Match);

fun map2prod1 f e [] ac = ac
  | map2prod1 f e (e2::es) ac = (f(e,e2))::(map2prod1 f e es ac);
fun map2prod0 f [] fs ac = ac
  | map2prod0 f (e::es) fs ac = map2prod1 f e fs (map2prod0 f es fs ac);

fun map2prod f es fs = map2prod0 f es fs [];

fun map2product f ps = map f (productl ps);
fun map2product2 f (s1,s2) = map f (product (s1,s2));
fun map2product3 f (s1,s2,s3) = map f (map (fn (a,(b,c)) => (a,b,c))
					   (product (s1,(product (s2,s3)))));

fun lmap00 (f,[],ac) = ac
  | lmap00 (f,e::es,ac) = (f e)::(lmap00 (f,es,ac))
fun lmap0 (f::fs,es,ac) = lmap0(fs,es,lmap00(f,es,ac))
  | lmap0 ([],_,ac) = ac;
fun lmap fs es = lmap0(fs,es,[]);

fun interleaveddifference ([],_) = []
  | interleaveddifference (es,[]) = es
  | interleaveddifference (e::es,f::fs) =
    if e = f then interleaveddifference(es,fs)
    else e::(interleaveddifference(es,f::fs));

fun foldfromto f (first,last) ac =
    if first > last then ac
    else foldfromto f (first+1,last) (f(first,ac));

fun mapfromto f (first,last) =
    if first > last then []
    else (f first)::(mapfromto f (first+1,last));
    
fun appfromto f (first,last) =
    if first > last then ()
    else (f first;appfromto f (first+1,last));

fun forallfromto f (first,last) =
    if first > last then true
    else if (f first) then forallfromto f (first+1,last)
    else false;
    
fun addtopartition eqf (e,[]) = [[e]]
  | addtopartition eqf (e,(e2::es)::ees) =
    if eqf (e,e2) then (e::e2::es)::ees
    else (e2::es)::(addtopartition eqf (e,ees));
fun partition eqf els = fold (addtopartition eqf) els [];

fun seqpart0 eqf (e1::e2::es,ac,ac2) =
    if eqf (e1,e2) then seqpart0 eqf (e2::es,e2::ac,ac2)
    else seqpart0 eqf (e2::es,[e2],ac::ac2)
  | seqpart0 eqf ([e],ac,ac2) = ac::ac2;
fun seqpartition eqf (e::es) = seqpart0 eqf (e::es,[e],[])
  | seqpartition eqf [] = [];

fun prefixes [] = [[]]
  | prefixes (e::es) = []::(map (fn p => e::p) (prefixes es));

fun nonemptyprefixes ls = filter (not o emptyp) (prefixes ls);

fun best0 v (bestvalue,beste,[]) = beste
  | best0 v (bestvalue,beste,e::es) =
    if (v e) > bestvalue
    then best0 v (v e,e,es)
    else best0 v (bestvalue,beste,es);
fun best v [] = raise Match
  | best v (e::es) = best0 v (v e,e,es);

fun intmin (a:int,b) = if a < b then a else b;
fun intmax (a:int,b) = if a > b then a else b;
fun realmin (a:real,b) = if a < b then a else b;
fun realmax (a:real,b) = if a > b then a else b;

fun setmax (r::rs) = revfold intmax rs r
fun setmin (r::rs) = revfold intmin rs r

fun setrmax (r::rs) = revfold realmax rs r
fun setrmin (r::rs) = revfold realmin rs r

fun log2 0 = 0
  | log2 1 = 0
  | log2 2 = 1
  | log2 n = 1+(log2 (n div 2));

fun intpow(n,~1) = 1
  | intpow(n,~2) = 1
  | intpow(n,~3) = 1
  | intpow(n,0) = 1
  | intpow(n,k) = n*(intpow(n,k-1));

fun appfromto f (s,t) = if s>t then ()
			else (f s; appfromto f (s+1,t))

(* Take first n elements from a list. *)

fun takefirst (0,_) = []
  | takefirst (_,[]) = []
  | takefirst (n,e::es) = e::(takefirst(n-1,es));

(* Split list to two, first n elements and the rest. *)

fun splitfirst0 (0,rest,ac) = (rev ac,rest)
  | splitfirst0 (_,[],ac) = (rev ac,[])
  | splitfirst0 (n,e::es,ac) = splitfirst0(n-1,es,e::ac);
fun splitfirst (n,l) = splitfirst0(n,l,[]);

(* Are all elements of the set same *)

fun allsame0 (e,[]) = true
  | allsame0 (e,e2::es) = e=e2 andalso allsame0(e,es);
fun allsame [] = true
  | allsame (e::es) = allsame0 (e,es);

fun allsameQ0 p e (c,[]) = true
  | allsameQ0 p e (c,b::bs) = e(c,p b) andalso allsameQ0 p e (c,bs);
fun allsameQ p e [] = true
  | allsameQ p e [b] = true
  | allsameQ p e (b::bs) = allsameQ0 p e (p b,bs);

fun vec2list v = Vector.foldl (op ::) [] v;

fun everypair [] = []
  | everypair (e::es) = (map (fn e' => (e,e')) es)@(everypair es);

fun inOption f (SOME d) = SOME (f d)
  | inOption f NONE = NONE;

fun isSOME (SOME _) = true
  | isSOME NONE = false;

fun mergesort f [] = []
  | mergesort f [e] = [e]
  | mergesort f ls =
    let
      fun mergesplit ([],ac1,ac2) = (ac1,ac2)
	| mergesplit ([e],ac1,ac2) = (e::ac1,ac2)
	| mergesplit (e1::e2::es,ac1,ac2) = mergesplit(es,e1::ac1,e2::ac2)
      fun merge ([],ls) = ls
	| merge (ls,[]) = ls
	| merge (ee1 as (e1::es1),ee2 as (e2::es2)) =
	  if f (e1,e2)
	    then e1::(merge(es1,ee2))
	  else e2::(merge(ee1,es2))
      val (ls1,ls2) = mergesplit (ls,[],[])
    in
      merge(mergesort f ls1,mergesort f ls2)
    end;
  
fun sort f ls = mergesort f ls;
