
(* 2017 (C) Jussi Rintanen *)

structure SATSOLVERLrVals =
  SATSOLVERLrValsFun(structure Token = LrParser.Token);
     
structure SATSOLVERLex = 
  SATSOLVERLexFun(structure Tokens =  SATSOLVERLrVals.Tokens);
        
structure SATSOLVERParser=
  Join(structure ParserData = SATSOLVERLrVals.ParserData
       structure Lex=SATSOLVERLex
       structure LrParser=LrParser);

val invoke = fn lexstream =>
  let val print_error = fn (s,i:int,_) =>
    TextIO.output(TextIO.stdOut,"Error, character " ^
                  (Int.toString i) ^ ", " ^ s ^ "\n")
  in SATSOLVERParser.parse(0,lexstream,print_error,())
  end;

val xDIMACSparse = fn filename => 
    let
      val infile = TextIO.openIn filename
      fun readstring () =
          let val line = TextIO.inputLine infile
          in
              (case line of
                   NONE => (TextIO.closeIn infile;"")
                 | SOME line => line)
          end
      val lexer = SATSOLVERParser.makeLexer (fn _ => readstring ())
      val dummyEOF = SATSOLVERLrVals.Tokens.EOF(0,0)
      fun loop lexer =
           let val (result,lexer) = invoke lexer
               val (nextToken,lexer) = SATSOLVERParser.Stream.get lexer
           in
             result
             (* if SATSOLVERParser.sameToken(nextToken,dummyEOF) then ()
              else loop lexer *)
           end
        val result = loop lexer
        val _ = TextIO.closeIn infile
     in
       result
    end;

