/*
	$Id: file.h,v 1.2 2001/03/04 16:49:30 rogue Exp $

	Copyright (c) 1999 - 2001 Xforge project
*/

#ifndef _FILE_H
#define _FILE_H

/* magic for various formats */
#define MAGIC_SUN 0x2e736e64		/* ".snd" - Sun / NeXT Audio */
#define MAGIC_RIFF 0x52494646		/* "RIFF" - Microsoft */
#define MAGIC_RIFX 0x52494658		/* "RIFX" - Microsoft */
#define MAGIC_FORM 0x464f524d		/* "FORM" - 8SVX, AIFF, AIFC etc */

#define MAGIC_FORM_AIFF 0x41494646	/* "AIFF" */
#define MAGIC_FORM_AIFC 0x41494643	/* "AIFC" */

/* Sun Audio file format codes (supported ones) */
#define SND_FORMAT_LINEAR_8 2
#define SND_FORMAT_LINEAR_16 3
#define SND_FORMAT_LINEAR_24 4
#define SND_FORMAT_LINEAR_32 5

/* AIFF / AIFF-C chunk IDs (supported ones) */
#define ckID_COMM 0x434f4d4d		/* "COMM" */
#define ckID_SSND 0x53534e44		/* "SSND" */

/* endianness */
#define ENDIAN_LITTLE 0
#define ENDIAN_BIG 1

struct file_handle {
	char *path;			/* file name (long) */
	FILE *fp;			/* file pointer */
	unsigned long file_size;	/* file size on disk */
	unsigned long data_offset;	/* offset of wave data */
	unsigned long data_size;	/* amount of wave data */
	unsigned long samples;		/* number of samples */
	unsigned long magic;		/* magic (e.g. ".snd") */
	unsigned long magic2;		/* secondary magic (e.g. "AIFF") */
	int filef;			/* file format (see xforge.h) */
	int bits;			/* bits per sample */
	int issigned;			/* data is signed */
	int endianness;			/* endianness of data */
	int channels;			/* number of channels */
	int rate;			/* samples per second */
	int datalen;			/* length of data */
};

#endif /* !_FILE_H */
