/*
	$Id: xforge.h,v 1.5 2001/03/04 16:51:23 rogue Exp $

	Copyright (c) 1999 - 2001 Xforge project
*/

#ifndef _XFORGE_H
#define _XFORGE_H

#include "version.h"

#define DEFAULT_TITLE "Xforge"		/* default window title */
#define EMEM_MSG "Memory allocation failed"
#define ENUM_MSG "Numeric error, value not applied"

#ifdef __STDC__
#define I32WRAP 2147483648U
#else
#define I32WRAP 2147483648
#endif

#ifndef DSPDEV
#define DSPDEV "/dev/dsp"		/* DSP device name */
#endif /* !DSPDEV */
#ifndef DSPBUF
#define DSPBUF 8192			/* DSP buffer size */
#endif /* !DSPBUF */
#ifndef LIBDIR				/* Xforge lib directory - FIXME */
#define LIBDIR "/usr/X11R6/lib/xforge"
#endif

/* play modes */
#define PMODE_MONO 0
#define PMODE_STEREO 1
#define PMODE_QUAD 2
#define PMODE_8 0
#define PMODE_16 4
#define PMODE_24 8
#define PMODE_32 16
#define PMODE_M8 (PMODE_MONO | PMODE_8)
#define PMODE_M16 (PMODE_MONO | PMODE_16)
#define PMODE_M24 (PMODE_MONO | PMODE_24)
#define PMODE_M32 (PMODE_MONO | PMODE_32)
#define PMODE_S8 (PMODE_STEREO | PMODE_8)
#define PMODE_S16 (PMODE_STEREO | PMODE_16)
#define PMODE_S24 (PMODE_STEREO | PMODE_24)
#define PMODE_S32 (PMODE_STEREO | PMODE_32)

/* filter types */
#define F_LP 1
#define F_HP 2
#define F_BP 3
#define F_BR 4

/* window functions */
#define WFUNC_RECTANGULAR 0
#define WFUNC_BARTLETT 1
#define WFUNC_BLACKMAN 2
#define WFUNC_HAMMING 3
#define WFUNC_HANNING 4

/* buffer structure for keeping book of guis */
struct buffer {
	struct buffer *succ;	/* next buffer */
	/* buffer data */
	float *data;		/* data pointer */
	float *undo_data;
	int len;		/* length in samples */
	int undo_len;
	char *path;		/* path */
	char *name;		/* file name == basename(path) */
#define FILEF_RAW 0
#define FILEF_SUN 1
#define FILEF_RIFF 2
#define FILEF_RIFX 3
#define FILEF_AIFF 4
#define FILEF_AIFC 5
	int filef;		/* file format */
	int channels;		/* number of channels; 0 = mono; 1 = stereo */
	int undo_channels;
	int rate;		/* sampling rate */
	int format;		/* sample format */
	int bits;		/* number of bits / sample */
	int mod;		/* modified? 0 = no, 1 = yes */
	/* misc */
	int dispstart;		/* first sample displayed */
	int dispend;		/* last sample displayed */
	int selstart;		/* selection start sample */
	int selend;		/* selection end sample */
	int selmask;		/* selection channel mask */
	int p_loop;		/* player: loop */
	/* X and M*tif stuff */
	Display *display;
	Screen *screen;
	GC lgc;			/* line drawing graphics context */
	XGCValues lgcv;
	GC sgc;			/* selection graphics context */
	XGCValues sgcv;
	XmString xname;		/* name as XmString */
	short m_x0;		/* mouse positions when selecting with mouse */
	short m_y0;
	short m_x1;
	short m_y1;
	int old_selx0;		/* selection display backup */
	int old_selx1;
	int old_selw;
	int old_selmask;
	Widget	top_wid,		/* toplevel */
		mainw,			/* main window */
		menubar,		/* the menu bar */
		form,			/* work area */
		statframe,		/* the status frame */
		statlabel,		/* the status label */
		scrollbar,		/* the scroll bar */
		canvas,			/* drawing area */
		open_dialog,		/* filesel (open) dialog */
		save_dialog,		/* filesel (save) dialog */
		clear_dialog,		/* clear dialog */
		addws_dialog,		/* add workspace dialog */
		close_dialog,		/* close dialog */
		param_dialog,		/* parameter dialog */
		param_dialog_frate,
		param_dialog_srw,
		param_dialog_fchan,
		param_dialog_chm,
		param_dialog_ch1,
		param_dialog_ch2,
		param_dialog_fbits,
		param_dialog_bm,
		param_dialog_b8,
		param_dialog_b16,
		param_dialog_b24,
		param_dialog_b32,
		param_dialog_ffmt,
		param_dialog_fm,
		param_dialog_fraw,
		param_dialog_fsun,
		param_dialog_friff,
		param_dialog_frifx,
		param_dialog_faiff,
		param_dialog_faifc,
		param_dialog_sep,
		param_dialog_apply,
		param_dialog_cancel,
		param_dialog_help,
		resample_dialog,	/* resample dialog */
		resample_dialog_rc,
		resample_dialog_srw,
		resample_dialog_wlw,
		resample_dialog_wfm,
		resample_dialog_rect,
		resample_dialog_bart,
		resample_dialog_black,
		resample_dialog_ham,
		resample_dialog_han,
		resample_dialog_sep,
		resample_dialog_apply,
		resample_dialog_cancel,
		mono_dialog,
		mono_dialog_bal,
		mono_dialog_sep,
		mono_dialog_apply,
		mono_dialog_cancel,
		mix_dialog,		/* mix dialog */
		mix_dialog_list,
		mix_dialog_ratio,
		mix_dialog_auto,
		mix_dialog_sep,
		mix_dialog_apply,
		mix_dialog_cancel,
		vol_dialog,		/* volume dialog */
		vol_dialog_rc,
		vol_dialog_st,
		vol_dialog_end,
		vol_dialog_sep,
		vol_dialog_apply,
		vol_dialog_cancel,
		echo_dialog,		/* echo dialog */
		echo_dialog_rc,
		echo_dialog_gain,
		echo_dialog_fb,
		echo_dialog_delay,
		echo_dialog_sep,
		echo_dialog_apply,
		echo_dialog_cancel,
		flan_dialog,		/* flange dialog */
		flan_dialog_rc,
		flan_dialog_delay,
		flan_dialog_depth,
		flan_dialog_freq,
		flan_dialog_sep,
		flan_dialog_apply,
		flan_dialog_cancel,
		rev_dialog,		/* reverb dialog */
		rev_dialog_rc,
		rev_dialog_dry,
		rev_dialog_wet,
		rev_dialog_damp,
		rev_dialog_fb,
		rev_dialog_sep,
		rev_dialog_apply,
		rev_dialog_cancel,
		filt_dialog,		/* filter dialog */
		filt_dialog_rc,		/* filt manager - RowColumn */
		filt_dialog_lcw,
		filt_dialog_ucw,
		filt_dialog_om,
		filt_dialog_o1,
		filt_dialog_o2,
		filt_dialog_tm,
		filt_dialog_tlp,
		filt_dialog_thp,
		filt_dialog_tbp,
		filt_dialog_tbr,
		filt_dialog_sep,
		filt_dialog_apply,
		filt_dialog_cancel,
		comp_dialog,		/* compress dialog */
		comp_dialog_rc,
		comp_dialog_dyn,
		comp_dialog_vel,
		comp_dialog_sep,
		comp_dialog_apply,
		comp_dialog_cancel,
		mbe[10],		/* menu bar entries */
		pulld[10];		/* pulldown menus */
};

#endif /* !_XFORGE_H */
