/*
	$Id: glob.h,v 1.4 2000/12/30 01:25:39 rogue Exp $

	Copyright (c) 1999, 2000 Xforge project
*/

#ifndef _GLOB_H
#define _GLOB_H
#include <sys/errno.h>

/* global variables */
extern char *progname;
extern char *dspdev;
extern int dspbuf;
extern unsigned char *b1, *b2;
extern const char *license;
extern struct buffer *clip;
extern Widget quit_dialog, about_dialog, license_dialog, top_wid;
extern Cursor xcwatch;

/* prototypes for global functions */
/* xforge.c */
extern void syserr(const char *);
extern void xferr(const char *);
extern void spawn_gui(char *);
/* file.c */
extern int io_openfile(struct buffer *, char *);
extern int io_savefile(struct buffer *, char *);
/* clip.c */
extern void buf_copy(struct buffer *);
extern void buf_cut(struct buffer *);
extern void buf_paste(struct buffer *);
extern void buf_swaptoclip(struct buffer *);
extern void buf_delete(struct buffer *);
/* ossplay.c */
extern void oss_play_all(struct buffer *);
extern void oss_play_range(struct buffer *);
extern void oss_play_stop(struct buffer *);
/* eff.c */
extern void clamp(struct buffer *);
extern void eff_volume(struct buffer *, float, float);
extern void eff_echo(struct buffer *, float, float, float);
extern void eff_compress(struct buffer *, float, float);
extern void eff_reverb(struct buffer *, float, float, float, float);
extern void eff_bfilter(struct buffer *, float, float, int, int);
extern void eff_flange(struct buffer *, float, float, float);
/* resample.c */
extern void resample(struct buffer *, int, int, int);
/* help.c */
extern void spawn_help(const char *);

#endif /* !_GLOB_H */
