/*
	$Id: resample.c,v 1.2 2000/04/22 11:51:00 rogue Exp $

	Copyright (c) 1999, 2000 Xforge project
*/

#include <Xm/Xm.h>
#include <math.h>
#include <stdlib.h>
#include "xforge.h"
#include "glob.h"

static void window(float *p, int m, int wfunc) {
	int i;

	switch (wfunc) {
		case WFUNC_RECTANGULAR:
			for (i = 0; i < m; i++)
				p[i] = 1.0f;
			break;
		case WFUNC_BARTLETT:
			for (i = 0; i < m; i++)
				p[i] = 1.0f - 2.0f * (float)abs(i - (m - 1)/2)
					/ (float)(m - 1);
			break;
		case WFUNC_BLACKMAN:
			for (i = 0; i < m; i++)
				p[i] = 0.42f - 0.5f * cos(2.0f * M_PI * i) /
					(float)(m - 1) + 0.08f *
					cos(4.0f * M_PI * i) / (float)(m - 1);
			break;
		case WFUNC_HAMMING:
			for (i = 0; i < m; i++)
				p[i] = 0.54f - 0.46 * cos(2.0f * M_PI * i) /
					(float)(m - 1);
			break;
		case WFUNC_HANNING:
			for (i = 0; i < m; i++)
				p[i] = 0.5f * (1.0f - cos(2.0f * M_PI * i) /
					(float)(m - 1));
			break;
	}
}

static float sinc(float x) {
	/* FIXME */
	if (fabs(x) < 0.0001f)
		return 1.0f;
	else
		return (float)(sin(x) / x);
}

void resample(struct buffer *buf, int newrate, int wlen, int wfunc) {
	float *w;

	if (!(buf->data))
		return;

	if (!(w = malloc(wlen * sizeof(float)))) {
		syserr(EMEM_MSG);
		return;
	}

	if (undo_create(buf)) {
		free(w);
		return;
	}

	window(w, wlen, wfunc);

	xferr("resampling not implemented");

	if (buf->len < wlen) {
	} else {
	}

	/* just in case, clamp the signal */
	clamp(buf);
	free(w);
	buf->mod = 1;
}
