/*
	$Id: glob.h,v 1.2 2000/01/03 17:14:54 rogue Exp $

	Copyright (c) 1999 Xforge project
*/

#ifndef _GLOB_H
#define _GLOB_H
#include <sys/errno.h>

/* global variables */
extern char *progname;
extern char *dspdev;
extern const char *license;
extern struct buffer *clip;
extern struct buffer *root;
extern int nbuf;

/* prototypes for global functions */
/* xforge.c */
extern void syserr(char *);
extern void xferr(char *);
/* file.c */
extern int io_openfile(struct buffer *, char *);
extern int io_savefile(struct buffer *, char *);
/* clip.c */
extern void buf_copy(struct buffer *);
extern void buf_cut(struct buffer *);
extern void buf_paste(struct buffer *);
extern void buf_swaptoclip(struct buffer *);
extern void buf_delete(struct buffer *);
/* ossplay.c */
extern void oss_play_all(struct buffer *);
extern void oss_play_range(struct buffer *);
extern void oss_play_stop(struct buffer *);
/* eff.c */
extern void clamp(struct buffer *);
extern void eff_volume(struct buffer *, float, float);
extern void eff_echo(struct buffer *, float, float, float);
extern void eff_compress(struct buffer *, float, float);
extern void eff_bfilter(struct buffer *, float, float, int, int);
/* bufutil.c */
extern struct buffer *add_buf(void);
extern void remove_buf(struct buffer *);
extern int undo_create(struct buffer *);
extern void undo(struct buffer *);
extern void buf_remdc(struct buffer *);
extern void buf_addws(struct buffer *, int);
extern void buf_invert(struct buffer *);
extern void buf_reverse(struct buffer *);
extern void buf_tomono(struct buffer *, float);
extern int buf_mtosshuffle(struct buffer *);
extern int buf_stomshuffle(struct buffer *);
/* resample.c */
extern void resample(struct buffer *, int, int, int);

#endif /* !_GLOB_H */
