/*	
 *	paa.c		C-ohjelmoinnin harjoitustyö, Launo Tuuri (c) 1997
 *	-----
 *	
 * Tarkoitus: Käsittele komentoriviparametrit, ohjaa lukemista ja muotoiltua
 *	tulostusta. 
 *
 *	Aseta oletusalkuarvot globaaleihin muuttujiin 
 *	int tasaa - älä tasaa tulosteen oikeaa marginaalia, ja 
 *	FILE *t - lue syöte stdin:istä, ei tiedostosta
 *	sekä muuttujaan
 *	static int rivpit - tulosteen suurin rivinpituus 75, 
 *	(ja komentoriviparametrien mukaan muuta alkuarvoja)
 *
 *	Määrittele myös kaikki muut tässä ohjelmassa käytetyt globaalit 
 *	muuttujat.
 *
 * Funktiot: static void tulkitse_ppar(char *p)
 *	static void vieras_parametri(char *vp)
 *	static void tulkitse_parametrit(int argc, char *argv[])
 *	int main(int argc, char *argv[])
 */
 

#include <stdio.h>
#include <string.h>
#include "ht.h"

/* Tästä tiedostosta käsin käytetyt muitten tiedostojen funktiot: */
/* lue.c: */
int luerivi(char* ri, int maxp);
void sanavalit_kuntoon(char* ri);
/* tulosta.c */
void tulosta(char *rivi, int rivpit);

/* Globaalit muuttujat: */
int tasaa = 0;
FILE *t = stdin;
char tul_pusk[MAXSRP+MAX_RP] = {'\0'};

static int rivpit= 75;

/*
 * Funktion tarkoitus: Tulkitse "-p" -alkuiset komentoriviparametrit.
 *	Funktion tulkitse_parametrit(int argc, char *argv[]) apufunktio
 * Parametrit: "-p" -alkuinen komentoriviparametri
 */
static void tulkitse_ppar(char *p)
{
	int i, pit = 0;
	
	for (i=2; i<strlen(p); ++i)
		pit = 10 * pit + (p[i] - '0');
	if (pit >= MIN_RP && pit <= MAX_RP)
		rivpit = pit; /* globaalin muuttujan arvon uudelleenasetus */
	else {
		fprintf(stderr, "Toivotun rivinpituuden on oltava "
			"välillä %d...%d \n", MIN_RP, MAX_RP);
		exit(1);
	}
}

/*
 * Funktion tarkoitus: Tulosta virheilmoitus. Funktion 
 *	tulkitse_parametrit(int argc, char *argv[]) apufunktio
 * Parametrit: virheellinen komentoriviparametri
 */
static void vieras_parametri(char *vp)
{
	fprintf(stderr, "Parametri \"%s\" on tuntematon - "
		"ohjelmaa kuitenkin jatketaan \n", vp);
}

/*
 * Funktion tarkoitus: Käsittele komentoriviparametrit. Tarvittaessa aseta
 *	globaaleihin muuttujiin uudet arvot tai anna virheilmoitukset 
 *	lopettaen samalla koko ohjelman suoritus - joko itse tai käyttäen 
 *	apufunktioita tulkitse_parametri_(char *p) ja 
 *	vieras_parametri(char *vp)
 * Parametrit: int argc - komentoriviparametrien lukumäärä ja 
 *	char *argv[] - niiden arvot
 */
static void tulkitse_parametrit(int argc, char *argv[])
{
	int i, tied_nimi_annettu = 0;
	
	for (i=1; i<argc; ++i) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				case 'p':
					tulkitse_ppar(argv[i]);
					break;
				case 't':
					tasaa = 1;
					break;
				default:
					vieras_parametri(argv[i]);
					break;
			}
		}
		else {
			if (!tied_nimi_annettu) {
				tied_nimi_annettu = 1;
				if ((t = fopen(argv[i], "r")) == NULL) {
					fprintf(stderr, "Tiedostoa \"%s\" "
						"ei löytynyt!\n", argv[i]);
					exit(1);
				}
			}
			else {
				fprintf(stderr, "Anna käsiteltäväksi vain "
					"yksi tiedosto kerrallaan! \n");
				exit(1);
			}
		}
	}
}

/*
 * Funktion tarkoitus: Lähetä komentoriviparametrit funktiolle
 *	tulkitse_parametrit(int argc, char *argv[]), lue rivejä syötteestä, 
 *	(stdin tai tiedosto) funktion luerivi(char* ri, int maxp) avulla, 
 *	esimuotoile ne funktion sanavalit_kuntoon(char* ri) avulla, ja
 *	lähetä eteenpäin ne tulostuksen muotoilua hoitavalle funktiolle 
 *	tulosta(char *rivi)
 * Parametrit: int argc - komentoriviparametrien lukumäärä ja 
 *	char *argv[] - niiden arvot
 * Palautus: 0 - tieto käyttöjärjestelmälle, että ohjelmasta on poistuttu 
 *	normaalilla tavalla
 */
int main(int argc, char *argv[])
{
	int m;
	char rivi[MAXSRP];

	tulkitse_parametrit(argc, argv);
	while ((m = luerivi(rivi, MAXSRP)) > 0) {
		sanavalit_kuntoon(rivi);
		tulosta(rivi, rivpit);
	}
	tulosta("\n", rivpit);
	return 0;
}
