/*	
 *	lue.c		C-ohjelmoinnin harjoitustyö, Launo Tuuri (c) 1997
 *	-----
 *	
 * Tarkoitus: Lue syötteestä rivejä muotoillen ne niin, että
 *	jokaisen sanan edessä on aina vain yksi välilyönti, ja 
 *	rivinloppuinen rivinvaihtomerkki on poistettu. Jos luettu
 *	rivi on "epämääräinen", eli sisältää vain välilyöntejä yms. eikä
 *	niiden lisäksi kuin yksiä muuntyyppistä merkkejä, kuten esim.
 *	"----- ----   --", korvaa koko rivi pelkän rivinvaihtomerkin 
 *	sisältävällä rivillä.
 *
 * Käytetyt globaalit muuttujat: FILE *t - luetaanko syöte stdin:istä 
 *	vai tiedostosta
 *
 * Funktiot: int luerivi(char* ri, int maxp)
 *	static int ei_tekstirivi(char *rivi)
 *	void sanavalit_kuntoon(char* ri)
 *
 * Käytetyt muitten tiedostojen funktiot: -
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "ht.h"

extern FILE *t;

/*
 * Funktion tarkoitus: Lue syöttestä yksi rivi parametrina annettuun 
 *	merkkitaulukkoon. Poista rivin lopusta '\n'
 * Parametrit: char *ri - osoitin merkkitaulukkoon, int maxp - lue riviltä 
 *	merkkejä korkeintaan
 * Palautus: rivin pituus, tai 0, jos tiedosto loppui. (Tyhjälläkin rivillä
 *	on yksi merkki: rivinvaihtomerkki!)
 */
int luerivi(char *ri, int maxp)
{
	int c, i;
	for (i=0; i<maxp-1 && (c=getc(t)) != EOF && c != '\n'; ++i) {
		if (i == 0)
			if (c != ' ')
				ri[i++] = ' ';
		ri[i] = c;
	}
	if (c == '\n' && i == 0) {
		ri[i] = c;
		++i;
	}
	ri[i] = '\0';
	return i;
}

/*
 * Funktion tarkoitus: Tutki, onko rivissä välilyöntien yms. lisäksi
 *	muunkin tyyppisiä merkkejä. Funktion sanavalit_kuntoon(char* ri)
 *	apufunktio.
 * Parametrit: char *rivi - osoitin merkkitaulukkoon
 * Palautus: 1, jos rivissä oli vain välilyöntejä yms. ja korkeintaan yhtä
 *	muuta merkkiä, esim. "----- ----   --", muuten 0
 */
static int ei_tekstirivi(char *rivi)
{
	int a, i = 0, j;
	
	while (isspace(rivi[i]) && i < strlen(rivi))
		++i;
	a = rivi[i++];
	for (j=i; j<strlen(rivi); ++j)
		if (!isspace(rivi[j]) && rivi[j] != a)
			return 0;
	return 1;
}

/*
 * Funktion tarkoitus: Muotoile annettu rivi niin, että vain jokaisen 
 *	sanan edessä on aina yksi välilyönti. Poista kaikki muut 
 *	välilyönnit, sarkainmerkit jne. MUTTA jos kyseessä on rivi, joka 
 *	ei ilmeisesti sisällä sanoja, korvaa se rivillä, jossa on
 *	pelkkä välilyönti.
 * Parametrit: char *ri - osoitin merkkitaulukkoon
 */
void sanavalit_kuntoon(char* ri)
{
	char apu[MAXSRP];
	int i, j = 0, ekavali = 1;
	
	if (ei_tekstirivi(ri))
		strcpy(ri, "\n");
	else {	
		for (i=0; ri[i]; ++i) {
			if (isspace(ri[i])) {
				if (ekavali) {
					apu[j++] = ' ';
					ekavali = 0;
				}
			}
			else {
				ekavali = 1;
				apu[j++] = ri[i];
			}
		}
		if (apu[j-1] == ' ')
			--j;
		apu[j] = '\0';
		strcpy(ri, apu);
	}
}
