/*
 *	jaa.c		C-ohjelmoinnin harjoitustyö, Launo Tuuri (c) 1997
 *	-----
 *	
 * Tarkoitus: Yritä jakaa saatu sana tavutussääntöjen ja rivillä 
 *	olevan tilan mukaan.
 *
 * Käytetty globaali muuttuja: char tul_pusk[]
 *
 * Funktiot: static int konsonantti(char m)
 *	static int vokaali(char m)
 *	static int tuplavokaali(char eka, char toka)
 *	void jaa(char *sana, int tilaa)
 *
 * Käytetyt muitten tiedostojen funktiot: -
 */


#include <string.h>
#include <ctype.h>
#include "ht.h"

extern int tasaa;
extern char tul_pusk[];

/*
 * Funktion tarkoitus: Tarkasta, onko ko. merkki konsonantti
 * Parametrit: merkki
 * Palautus: 1 jos on, muuten 0
 */
static int konsonantti(char m)
{
	char kon[] = "BCDFGHJKLMNPQRSTVWXZbcdfghjklmnpqrstvwxz";
	int i;
	
	for (i=0; kon[i]; ++i)
		if (m == kon[i])
			return 1;
	return 0;
}

/*
 * Funktion tarkoitus: Tarkasta, onko ko. merkki vokaali
 * Parametrit: merkki
 * Palautus: 1 jos on, muuten 0
 */
static int vokaali(char m)
{
	char vok[] = "AEIOUYÅÄÖaeiouyåäö";
	int i;

	for (i=0; vok[i]; ++i)
		if (m == vok[i])
			return 1;
	return 0;
}

/*
 * Funktion tarkoitus: Muodostavatko annetut kaksi merkkiä sellaisen
 *	kaksoisvokaalin, jonka väliin ei suomenkielisten tavutus-
 *	sääntöjen mukaan saa laittaa tavuviivaa?
 * Parametrit: kaksi merkkiä
 * Palautus: 1, jos muodostavat, muuten 0
 */
static int tuplavokaali(char eka, char toka)
{
	int i;
	char *tupvok[] = { "aa","ai","au","ee","ei","eu","ey","ie","ii",
			   "iu","oi","oo","ou","ui","uo","uu","yi","yy",
			   "yö","äi","äy","ää","öi","öy","öö" };
	char a[3];
	a[0] = tolower(eka);
	a[1] = tolower(toka);
	a[2] = '\0';

	for (i=0; i<25; ++i)
		if (!strcmp(a, tupvok[i]))
			return 1;
	return 0;
}

/*
 * Funktion tarkoitus: Yritä jakaaa annettu sana viimeisestä mahdollisesta 
 *	sellaisesta kohdasta, että jaetun sanan etuosa on lyhyempi 
 *	kuin annettu tila. Jos sana oli mahdollista jakaa, katkaise sana
 *	oikeasta kohdasta, lisää siihen '-', ja kopioi sen loppuosa 
 *	tulostuspuskurin alkuun, muuten kopioi sinne takaisin koko sana. 
 * Parametrit: osoite sanaan ja jäljellä oleva tila. Oleta, että sana 
 *	lähetetään jaettavaksi vain, jos se on tarpeen. Jaa siis 
 *	viimeisestä mahdollisesta kohdasta, vaikka tilaa olisikin koko 
 *	sanalle.
 * Huom: Yhdys-sanat pitää syöttää osa kerrallaan!
 */
void jaa(char *sana, int tilaa)
{
	char yli[MAXSRP];
	int i, j, k = 0, tvp = 0;
	int vmtvp = (tilaa < strlen(sana)) ? tilaa : strlen(sana);

	while (!vokaali(sana[k]) && k <= vmtvp)
		++k;
	for (i=++k; i<vmtvp; ++i) {
		if (konsonantti(sana[i])) {
			while (i <= vmtvp && !vokaali(sana[i]))
				++i;
			if (i <= vmtvp)
				tvp = i-1;
		}
		else if (!tuplavokaali(sana[i-1], sana[i])) {
			tvp = i;
		}
		else {
			do {
				++i;
				if (i > vmtvp)
					break;
				if (vokaali(sana[i]))
					tvp = i;
			} while (vokaali(sana[i]));
			--i;
		}
	}
	k = 1;		/* katkaise sana mahdollisesti tavutetun */
	yli[0] = ' ';	/* alkuosan jälkeen ja liitä loppuosa */
	j = i = tvp;	/* (tai koko sana) tulostuspuskurin alkuun */
	while (sana[i])
		yli[k++] = sana[i++];
	sana[j++] = '-';
	sana[j] = yli[k] = '\0';
	strcat(yli, tul_pusk);
	strcpy(tul_pusk, yli);
	if (tvp == 0)		/* tarkistukset yhdys-sanojen varalta */
		sana[0] = '\0';
	if (tvp > 1) {
		if (sana[j-2] == '-')
			sana[j-1] = '\0';
		if (tul_pusk[1] == '-') {
			for (i=1; tul_pusk[i]; ++i)
				tul_pusk[i] = tul_pusk[i+1];
			tul_pusk[i] = '\0';
		}
	}
}
