"""
pyS60dbgutil.py - a collection of miscellaneous functions and classes
                  to aid development work in PyS60 environment.

Copyright (C) 2006 - 2007 Lasse Huovinen

Latest version available at www.iki.fi/lasse/mobile/python.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301 USA
"""

import os
import os.path
import sys
    
def get_last_exception(which='all'):
    """
    Returns the last exception type, value or both as a string.
    Parameter which must have one of the values 'all', 'type', 'value'
    """
    except_type_and_value = sys.exc_info()[:2]
    if which == 'all':
        return str(except_type_and_value[0]) + ': ' + \
               str(except_type_and_value[1])
    elif which == 'type':
        return str(except_type_and_value[0])
    elif which == 'value':
        return str(except_type_and_value[1])
    return None

def remove_logs(directory, file_list):
    """
    A very simple helper function to remove the given list of files from
    the given directory.
    """
    for item in file_list:
        try:
            f = os.path.join(directory, item)
            os.remove(f)
        except:
            pass

class Logger:
    """
    Logging facility which allows log printing to screen and/or file.
    """
    __my_console = None
    __my_console_users = 0
    __original_stderr = None
    __original_stdout = None

    def __init__(self, toConsole=False, consolePrefix='', toFile=None):
        """
        toConsole - defines whether to write log messages to the screen.
        consolePrefix - a constant string appended to the head of each
        log message.
        toFile - if given the log messages will be written to the file, too.
        """
        self.prefix = consolePrefix
        self.console = toConsole
        if self.console:
            import series60_console
            import appuifw
            if Logger.__my_console_users == 0:
                Logger.__my_console = series60_console.Console()
                appuifw.app.body = Logger.__my_console.text

                Logger.__original_stderr = sys.stderr
                Logger.__original_stdout = sys.stdout
                sys.stderr = sys.stdout = Logger.__my_console
                print 'Logger console initialized'
            print self.prefix + ': ' + 'logging to console'
            Logger.__my_console_users += 1

        self.logfile = None
        if toFile != None:
            try:
                dest_dir = os.path.split(toFile)[0]
                if not os.path.isdir(dest_dir):
                    os.mkdir(dest_dir)
                self.logfile = file(toFile, 'a')
                self.logfile.write('Logging started at '+ \
                                   time.asctime() + '\n')
            except:
                #= Might be nice to notify the user that logging to file
                #= will not be done. ;-)
                self.logfile = None
                pass

    def close(self):
        """
        Stop logging.
        """
        if self.console:
            Logger.__my_console_users -= 1
            self.console = False
            if Logger.__my_console_users == 0:
                print 'Closing Logger console'
                if Logger.__original_stderr != None:
                    sys.stderr = Logger.__original_stderr
                if Logger.__original_stdout != None:
                    sys.stdout = Logger.__original_stdout

        if self.logfile != None:
            self.logfile.close()
            self.logfile = None

    def log(self, message):
        """
        Write the given log message to the screen and/or file depending on
        how the logger object was created.
        """
        if self.console:
            print self.prefix + ': ' + message
        if self.logfile != None:
            self.logfile.write(message+'\n')
            self.logfile.flush()
