"""
pyFTPclientS60 - an FTP client for S60 phones written in Python.

This file contains classes to handle configuration data.
"""

import os.path
import appuifw
import e32
import pyUtilsS60

global servers
global directories
global __settings_changed
global __configuration_file

__FTP_CONFIG_FILE = 'dat/ftpconf'
__FTP_CONFIG_VERS = '1'
__FTP_CONFIG_HEAD = '<---pyFTPclientS60 configuration file--->'

def write_config_header(cfile):
    """
    Writes a header to the configuration file. The file is validated based
    on this header.
    """
    cfile.write(__FTP_CONFIG_HEAD+'\n')
    cfile.write(__FTP_CONFIG_VERS+'\n')

def check_config_header(cfile):
    """
    Validate the configuration file based on the header information.
    """
    l = cfile.readline()
    if not l[:-1] == __FTP_CONFIG_HEAD:
        return False
    l = cfile.readline()
    if not l[:-1] == __FTP_CONFIG_VERS:
        return False
    return True

class cnf_favorite_servers:
    """
    Favorite servers configuration.
    """
    def __init__(self):
        self.nr_of_servers = 7
        self.server_lst = []
        for i in range(self.nr_of_servers):
            self.server_lst.append('<not selected>')
            
    def get_unicoded_server_lst(self):
        ulist = []
        for i in self.server_lst: ulist.append(unicode(i))
        return ulist

    def get_server(self, index):
        return self.server_lst[index]
        
    def set_server(self, index, server_name):
        self.server_lst[index] = server_name

    def select_server(self, index):
        if not self.get_server(index) == '<not selected>':
            cnf = appuifw.query(u'Leave item unassigned?', 'query')
            if cnf:
                self.set_server(index, '<not selected>')
                return
        server = appuifw.query(u'Server name or address', 'text')
        if server:
            self.set_server(index, server)

    def save_config(self, cfile):
        try:
            cfile.write(str(self.nr_of_servers)+'\n')
            for i in self.server_lst:
                cfile.write(i+'\n')
        except:
            appuifw.note(u'Configuration write error', 'error')

    def read_config(self, cfile):
        try:
            s = cfile.readline()
            s = s.rstrip()
            s = s.lstrip()
            nr_of_servers = int(s)
            for i in range(nr_of_servers):
                s = cfile.readline()
                if i < self.nr_of_servers:
                    s = s.rstrip()
                    s = s.lstrip()
                    self.set_server(i, s)
        except:
            appuifw.note(u'Configuration read error', 'error')

class cnf_directories:
    """
    Default directory configuration.
    """
    def __init__(self, rootpath):
        self.dl_directory = rootpath
        self.ul_directory = rootpath
        self.initial_typed_directory = '/'

    def get_download_dir(self):
        return self.dl_directory

    def get_upload_dir(self):
        return self.ul_directory

    def get_initial_typed_directory(self):
        return self.initial_typed_directory

    def set_download_dir(self):
        fb = pyUtilsS60.dirBrowser('Directory for downloads')
        dl_dir = fb.select(None)
        if not dl_dir: return
        if not os.path.isdir(dl_dir[0]):
            appuifw.note(u'Not a directory', 'error')
        else:
            self.dl_directory = dl_dir[0]

    def set_upload_dir(self):
        fb = pyUtilsS60.dirBrowser('Directory for uploads')
        ul_dir = fb.select(None)
        if not ul_dir: return
        if not os.path.isdir(ul_dir[0]):
            appuifw.note(u'Not a directory', 'error')
        else:
            self.ul_directory = ul_dir[0]

    def set_initial_typed_directory(self):
        pass

    def save_config(self, cfile):
        try:
            cfile.write(self.dl_directory+'\n')
            cfile.write(self.ul_directory+'\n')
            cfile.write(self.initial_typed_directory+'\n')
        except:
            appuifw.note(u'Configuration write error', 'error')

    def read_config(self, cfile):
        try:
            s = cfile.readline()
            s = s.rstrip()
            s = s.lstrip()
            if not s == '': self.dl_directory = s
            s = cfile.readline()
            s = s.rstrip()
            s = s.lstrip()
            if not s == '': self.ul_directory = s
            s = cfile.readline()
            s = s.rstrip()
            s = s.lstrip()
            if not s == '': self.initial_directory = s            
        except:
            appuifw.note(u'Configuration read error', 'error')

def ftp_settings():
    """
    FTP configuration interface.
    """
    global servers
    global directories
    global __settings_changed
    global __configuration_file
    
    tab_list = [u'Servers', u'Directories']
    __settings_changed = False

    def conf_exit():
        appuifw.app.set_tabs([], lambda x: None)
        pyUtilsS60.restore_app_info(current_app_info)        
        config_lock.signal()
        
    def setting_page(page_ix):
        appuifw.app.menu = []
        if page_ix == 0:
            def cb():
                global __settings_changed
                __settings_changed = True
                servers.select_server(lbox.current())
                appuifw.app.activate_tab(page_ix)
                lbox.set_list(servers.get_unicoded_server_lst(),
                              lbox.current())
            lbox = appuifw.Listbox(servers.get_unicoded_server_lst(), cb)
            appuifw.app.body = lbox
        elif page_ix == 1:
            def _make_lbox_menu():
                lbox_menu = [u'Downloads:']
                lbox_menu.append(u'- '+unicode(directories.get_download_dir()))
                lbox_menu.append(u'Uploads:')
                lbox_menu.append(u'- '+unicode(directories.get_upload_dir()))
                return lbox_menu
            def cb():
                global __settings_changed
                __settings_changed = True
                #= Tabs must removed and added again due to the fileBrowser
                #= used to selected the directories.
                appuifw.app.set_tabs([], lambda x: None)
                lbox_index = lbox.current()
                if lbox_index == 0 or lbox_index == 2:
                    #= Indexes 0 and 2 contain no parameters but just names.
                    #= See _make_lbox_menu() above.
                    pass
                elif lbox_index == 1:
                    directories.set_download_dir()
                elif lbox_index == 3:
                    directories.set_upload_dir()
                appuifw.app.set_tabs(tab_list, setting_page)
                appuifw.app.activate_tab(page_ix)
                lbox.set_list(_make_lbox_menu(), lbox.current())
            lbox = appuifw.Listbox(_make_lbox_menu(), cb)
            appuifw.app.body = lbox

    current_app_info = pyUtilsS60.save_current_app_info()

    appuifw.app.t = None
    config_lock = e32.Ao_lock()
    appuifw.app.exit_key_handler = conf_exit
    appuifw.app.set_tabs(tab_list, setting_page)
    appuifw.app.activate_tab(0)
    setting_page(0)
    config_lock.wait()

    if __settings_changed:
        cnf = appuifw.query(u'Save changes as default settings', 'query')
        if not cnf: return
        try:
            full_dir = os.path.split(__configuration_file)[0]
            if not os.path.isdir(full_dir):
                os.mkdir(full_dir)
            config_file = file(__configuration_file, 'wb')
        except:
            appuifw.note(u'Error while creating configuration file', 'error')
            return
        #= Each class writes its own data.
        write_config_header(config_file)
        servers.save_config(config_file)
        directories.save_config(config_file)
        config_file.close()
    else:
        appuifw.note(u'Settings not changed', 'conf')

def read_ftp_settings():
    """
    Read the editor settings from a configuration file.
    """
    global servers
    global directories
    global __configuration_file
    if os.path.isfile(__configuration_file):
        config_file = file(__configuration_file, 'r')
        if check_config_header(config_file) == True:
            servers.read_config(config_file)
            directories.read_config(config_file)
        config_file.close()

def init_ftp_settings(root_path):
    """
    Initialize the settings module.
    """
    global servers
    global directories
    global __configuration_file
    
    __configuration_file = os.path.join(root_path, __FTP_CONFIG_FILE)
    #= Check if the directory for configuration etc files exists. If the
    #= directory does not exist create it.
    try:
        full_dir = os.path.split(__configuration_file)[0]
        if not os.path.isdir(full_dir):
            os.mkdir(full_dir)
    except:
        appuifw.note(u'Error while creating configuration directory', 'error')
    servers = cnf_favorite_servers()
    directories = cnf_directories(full_dir)

if __name__ == '__main__':
    #= No point to run this file
    #= as a stand-alone program...
    pass
