#=
#= pyEdit for S60
#=
#= Copyright (c) 2005 - 2007 Lasse Huovinen
#=

#= Do not change. This id has been officially allocated from Symbian.
# SYMBIAN_UID=0x1027972E

import sys
import os.path
import appuifw
import e32

#=
#= Force importing from the local directory first.
#=
localpath = str(os.path.split(appuifw.app.full_name())[0])
sys.path  = [localpath] + sys.path
localpath = os.path.join(localpath, 'my')
sys.path  = [localpath] + sys.path

import pyEdit

if __name__ == '__main__':
    if e32.s60_version_info[0] == 2:
        #= 2nd Edition
        localpath = str(os.path.split(appuifw.app.full_name())[0])
        pyEdit.EDITOR_CONFIG_FILE = os.path.join(localpath,
                                                 pyEdit.EDITOR_CONFIG_FILE)
    else:
        #= 3rd Edition 
        localpath = str('.')
        drv = str(os.path.splitdrive(appuifw.app.full_name())[0])
        drv = os.path.join(drv, 'Data/Others')
        pyEdit.EDITOR_CONFIG_FILE = os.path.join(drv,
                                                 pyEdit.EDITOR_CONFIG_FILE)

    pyEdit.EDITOR_HELP_FILE  = os.path.join(localpath,
                                            pyEdit.EDITOR_HELP_FILE)
    try:
        pyEdit.pyEditorS60()
    except:
        etype, evalue = sys.exc_info()[:2]
        appuifw.note(u'Bug: ' + unicode(str(etype)+':'+str(evalue)),
                     'error')
    sys.exit()
