"""
bt_ui.py - yet another BlueTooth user interface.

Copyright (c) 2006 Lasse Huovinen
"""

import appuifw
import socket
import os.path
import pyS60uiutil

def send_over_bt(filename):
    """
    Discover the BlueTooth devices nearby and send the given file to
    the selected device.
    """
    def dummy_exit_handler():
        pass
    if not os.path.isfile(filename):
        appuifw.note(u'Not a regular file', 'error')
        return
    stored_gui_data = pyS60uiutil.save_current_app_info()
    appuifw.app.body = None
    appuifw.app.exit_key_handler = dummy_exit_handler
    appuifw.app.menu = []
    try:
        addr, serv = socket.bt_obex_discover()
        if addr == None or serv == None:
            appuifw.note(u'BlueTooth Discovery Error', 'error')
            pyS60uiutil.restore_app_info(stored_gui_data)
            return
        choices = serv.keys()
        choices.sort()
        lst = []
        for x in choices:
            lst.append(unicode(str(x)+u' #'+str(serv[x])))
        choice = appuifw.popup_menu(lst)
        if choice == None:
            pyS60uiutil.restore_app_info(stored_gui_data)
            return
        target = (addr, serv[choices[choice]])
        socket.bt_obex_send_file(target[0], target[1], unicode(filename))
        appuifw.note(u'File sent', 'conf')
    except socket.error, detail:
        err_msg = u'BlueTooth socket error: ' + unicode(detail)
        appuifw.note(err_msg, 'error')
    pyS60uiutil.restore_app_info(stored_gui_data)

if __name__ == '__main__':
    #send_over_bt('E:\\System\\Apps\\Python\\my\\testfile.txt')
    pass
