#include "camera.h"
#include <math.h>

Camera::Camera()
	: pos(3.0f, 2.0f, 3.0f),
	  dir(1.0f, 0.0f, 0.0f)
{
}

Camera::~Camera()
{
}

void Camera::update_dirs()
{
	float a = y_rot / 360.0f * 2.0f * 3.14159265f;
	float b = x_rot / 360.0f * 2.0f * 3.14159265f;

	dir.x = cos(-a) * cos(b);
	dir.y = sin(b);
	dir.z = sin(-a) * cos(b);

	right = m::normalize(m::cross(m::Vector3(0.0f, 1.0f, 0.0f), dir));
	up = m::normalize(m::cross(right, dir));
}