static const char* deferredDirectLightingFrag =
"\
uniform float width;\
uniform float offsetX;\
uniform float offsetY;\
uniform vec3 lightPosition;\
uniform vec3 lightIntensity;\
uniform vec3 lightDirection;\
uniform mat4 lightMatrix;\
\
uniform sampler2D positionMap;\
uniform sampler2D normalMap;\
uniform sampler2D colorMap;\
uniform sampler2DShadow shadowMap;\
\
varying vec2 coords;\
\
void main()\
{\
	vec3 position = texture2D(positionMap, coords).xyz;\
	vec3 normal = texture2D(normalMap, coords).xyz;\
\
	vec3 l = position - lightPosition;\
	float dist = length(l);\
	l = l / dist;\
	float i = max(0.0, dot(l, lightDirection)) * max(0.0, -dot(l, normal)) / (dist * dist);\
	i = min(i, 0.02);\
\
	vec4 p = lightMatrix * vec4(position, 1.0);\
	float len = length(p);\
	p /= len;\
	p.z -= 1.0;\
	float invpz = 1.0 / p.z;\
	p.x *= invpz;\
	p.y *= invpz;\
	p.z = (len - 0.1) * (1. / (30.0 - 0.1)) - 0.01;\
	p.w = 1.0;\
\
	p = 0.5 * p + 0.5;\
\
	if ($i:shadowmap_hack == 1)\
		p.xy = vec2(offsetX, offsetY) + p.xy * 0.5;\
\
	float shadow;\
	shadow  = shadow2D(shadowMap, p.xyz).r;\
	/*shadow += shadow2D(shadowMap, p + vec4(1.0/width, 0, 0, 0)) +\
	          shadow2D(shadowMap, p + vec4(-1.0/width, 0, 0, 0)) +\
	          shadow2D(shadowMap, p + vec4(0, 1.0/width, 0, 0)) +\
	          shadow2D(shadowMap, p + vec4(0, -1.0/width, 0, 0));\
	shadow *= 1.0 / 5;*/\
\
	vec3 v = lightIntensity * shadow * i;\
\
	gl_FragColor = vec4(v, 1.0);\
}\
";

static const char* deferredVertex =
"\
varying vec2 coords;\
\
void main()\
{\
	coords = gl_Vertex.xy;\
	gl_Position = ftransform();\
}\
";

#define THING(x, y)\
	"uv = vec2((gl_FragCoord.x - $f:split_n/2.0 + "#x".0) * invw, (gl_FragCoord.y - $f:split_m/2.0 + "#y".0) * invh);\
	 p = texture2D(positionMap, uv).xyz - realPosition;\
	 if (dot(p, p) < $f:position_threshold && dot(texture2D(normalMap, uv).xyz, realNormal) > $f:normal_threshold)\
		 indirectColor += vec4(texture2D(colorMap, uv).rgb, 1.0);"

static const char* filterDeferredFrag =
"\
uniform sampler2D positionMap;\
uniform sampler2D normalMap;\
uniform sampler2D colorMap;\
uniform sampler2D realColorMap;\
uniform sampler2D directLightingMap;\
\
uniform vec3 lightPosition;\
uniform vec3 lightIntensity;\
uniform vec3 lightDirection;\
uniform mat4 lightMatrix;\
\
const float near = 0.1;\
const float far = 50.0;\
const float invw = 1.0 / $f:screen_width;\
const float invh = 1.0 / $f:screen_height;\
const float half_n = $f:split_n / 2.0;\
const float half_m = $f:split_m / 2.0;\
\
void main()\
{\
	vec2 fc = gl_FragCoord.xy / vec2($f:screen_width, $f:screen_height);\
\
	vec3 realPosition = texture2D(positionMap, fc).xyz;\
	vec3 realNormal = texture2D(normalMap, fc).xyz;\
\
	vec4 indirectColor = vec4(0.0, 0.0, 0.0, 0.0);\
\
	/*float ii     = (gl_FragCoord.y - half_m) * invh;\
	float ii_inc = invh;\
	float jj0    = (gl_FragCoord.x - half_n) * invw;\
	float jj_inc = invw;\
	for (int i = 0; i < m; i++)\
	{\
		float jj = jj0;\
		for (int j = 0; j < n; j++, jj+=jj_inc)\
		{\
			vec2 uv = vec2(jj, ii);\
\
			vec3 p = texture2D(positionMap, uv).xyz - realPosition;\
			vec3 n = texture2D(normalMap, uv).xyz;\
			vec3 c = texture2D(colorMap, uv).xyz;\
\
			if (dot(n, realNormal) > $f:normal_threshold && dot(p, p) < ($f:position_threshold))\
				indirectColor += vec4(c, 1);\
		}\
		ii += ii_inc;\
	}*/\
\
	vec3 p, n, c;\
	vec2 uv;\
\
	" THING(0, 0) "\
	" THING(1, 0) "\
	" THING(2, 0) "\
	" THING(3, 0) "\
	" THING(0, 1) "\
	" THING(1, 1) "\
	" THING(2, 1) "\
	" THING(3, 1) "\
	" THING(0, 2) "\
	" THING(1, 2) "\
	" THING(2, 2) "\
	" THING(3, 2) "\
	" THING(0, 3) "\
	" THING(1, 3) "\
	" THING(2, 3) "\
	" THING(3, 3) "\
\
\
	indirectColor.xyz *= 1.0 / indirectColor.w;\
\
	vec3 directColor = texture2D(directLightingMap, fc).rgb;\
	vec3 realColor = texture2D(realColorMap, fc).xyz;\
\
	gl_FragColor = vec4(sqrt((indirectColor.rgb + directColor.rgb) * realColor), 1.0);\
}\
";

static const char* deferredDirectFrag = "\
uniform sampler2D positionMap;\
uniform sampler2D normalMap;\
\
uniform vec3 lightPosition;\
uniform vec3 lightIntensity;\
uniform vec3 lightDirection;\
uniform mat4 lightMatrix;\
uniform samplerCube shadowMap;\
\
const int n = $i:split_n;\
const int m = $i:split_m;\
const int screen_width = $i:screen_width;\
const int screen_height = $i:screen_height;\
const float near = 0.1;\
const float far = 50.0;\
const float invw = 1.0 / $f:screen_width;\
const float invh = 1.0 / $f:screen_height;\
const float half_n = $f:split_n / 2.0;\
const float half_m = $f:split_m / 2.0;\
\
vec2 jitters[16] = {\
	vec2(-2.5 + .306, -2.5 + .434), vec2(-1.5 + .850, -2.5 + .660), vec2(-0.5 + .442, -2.5 + .011), vec2( 0.5 + .425, -2.5 + .362),\
	vec2(-2.5 + .327, -1.5 + .579), vec2(-1.5 + .958, -1.5 + .403), vec2(-0.5 + .690, -1.5 + .362), vec2( 0.5 + .373, -1.5 + .523),\
	vec2(-2.5 + .992, -0.5 + .431), vec2(-1.5 + .814, -0.5 + .321), vec2(-0.5 + .095, -0.5 + .941), vec2( 0.5 + .176, -0.5 + .428),\
	vec2(-2.5 + .290,  0.5 + .992), vec2(-1.5 + .082,  0.5 + .893), vec2(-0.5 + .365,  0.5 + .683), vec2( 0.5 + .422,  0.5 + .397)\
};\
\
void main()\
{\
	vec2 fc = gl_FragCoord.xy / vec2($f:screen_width, $f:screen_height);\
\
	vec3 realPosition = texture2D(positionMap, fc).xyz;\
	vec3 realNormal = texture2D(normalMap, fc).xyz;\
\
	vec3 lv = realPosition - lightPosition;\
	float dist = length(lv);\
\
	lv *= 1.0 / dist;\
\
	float shadow;\
\
	if ($i:no_depth_cubemaps == 0)\
	{\
		vec3 v1 = normalize(cross(vec3(0.656, 0.87, 0.1), lv));\
		vec3 v2 = cross(v1, lv);\
\
		float m = 1.0 / dot(realNormal, lv);\
		v1 -= lv * (dot(v1, realNormal) * m);\
		v2 -= lv * (dot(v2, realNormal) * m);\
\
		for (int i = 0; i < 16; i++)\
		{\
			vec2 jit = jitters[i];\
			vec3 a = (lv + (v1 * jit.x + v2 * jit.y) / 324.0) * dist;\
			float dist2 = max(max(abs(a.x), abs(a.y)), abs(a.z));\
\
			float depth = textureCube(shadowMap, a).r;\
			depth = far * near / (far - depth * (far - near)) + 0.07;\
			if (depth > dist2)\
				shadow += 1.0 / 16.0;\
		}\
\
		/*shadow = shadowCube(shadowMap, vec4(lv, dist)).r;*/\
	}\
	else\
	{\
		shadow = 1.0;\
	}\
\
	float tmp = (max(0.0, -dot(lv, realNormal)) * shadow / (dist * dist));\
	if ($i:spot == 1)\
		tmp *= max(0.0, dot(lv, lightDirection));\
\
	gl_FragColor = vec4(lightIntensity * tmp, 1.0);\
}\
";

static const char* ambientFrag = "\
uniform sampler2D realColorMap;\
\
const int screen_width = $i:screen_width;\
const int screen_height = $i:screen_height;\
\
void main()\
{\
	vec2 fc = gl_FragCoord.xy / vec2(screen_width, screen_height);\
	gl_FragColor = texture2D(realColorMap, fc) * 0.15;\
}\
";

static const char* mul16Frag = "\
uniform sampler2D map;\
uniform sampler2D map2;\
\
const int screen_width = $i:screen_width;\
const int screen_height = $i:screen_height;\
\
void main()\
{\
	vec2 fc = gl_FragCoord.xy / vec2(screen_width, screen_height);\
	gl_FragColor = sqrt(texture2D(map, gl_TexCoord[0].xy) * texture2D(map2, fc));\
}\
";
