#ifndef _raytracer_h_
#define _raytracer_h_

#include "kdtree.h"

class RayTracer
{
public:
	RayTracer();
	~RayTracer();

	void feedObject(const class ObjLoader&);

	void update();

	bool intersect(const m::Vector3& pos, const m::Vector3& dir, m::Vector3& p, m::Vector3& n, m::Vector3& c);

private:
	struct Triangle
	{
		int a, b, c;
	};

private:
	KDTree kdtree;
	std::vector<Triangle> triangleNormals;
	std::vector<m::Vector3> vertexNormals;
	std::vector<m::Vector3> faceNormals;
	std::vector<m::Vector3> faceColors;
};

#endif
