#ifndef _CUBEMAP_H
#define _CUBEMAP_H

#include "glutil.h"
#include "Vector.h"

class CubeMap
{
public:
	CubeMap(int size);
	~CubeMap();

	void setPosition(const m::Vector3& p);
	void setDirection(const m::Vector3& d);

	void getMatrix(float* m);

	void render(void (*render)(void*), void* user);
	//void prepareRendering(int n);
	//void doneRendering(int n);

public:
	GLuint fb[6];
	GLuint texture;
	GLuint texture2;

	int size;

	m::Vector3 pos;
	m::Vector3 dir;

	m::Vector3 right;
	m::Vector3 up;
};

#endif
