function [H12,H13]=tablehomography(d,K,Rs,ts)

plane=[0 1 0 d]';
plane=plane/plane(end);
%n=plane(1:3);

R=Rs{1};t=ts{1};

%plane in canonical frame
H3D=[R t; zeros(1,3) 1];
pp=inv(H3D)'*plane;
pp=pp/pp(4);
v=pp(1:3);
n=v(:);

R2=Rs{2}*R';
t2=-R2*t+ts{2};

R3=Rs{3}*R';
t3=-R3*t+ts{3};

Ps{1}=K*[eye(3) zeros(3,1)];
Ps{2}=K*[R2 t2];
Ps{3}=K*[R3 t3];

iK=inv(K);
H12=K*(R2-t2*n')*iK;
H13=K*(R3-t3*n')*iK;

%A2=Ps{2}(:,1:3);
%av2=Ps{2}(:,4);
%H12=A2-av2*v';

%A3=Ps{3}(:,1:3);
%av3=Ps{3}(:,4);
%H13=A3-av3*v';
