function p=conic2ellpar(C)

tol=10^(-9);
if norm(C-C','fro')~=0
  disp('In conic2ellpar: C not symmetric!');
  %keyboard;
end

a=C(1,1); b=C(1,2); d=C(1,3);
c=C(2,2); f=C(2,3); g=C(3,3);

detA=a*c-b^2;

if (a*c-b^2)<=0 | det(C)==0
  disp('In conic2ellpar: C not an ellipse');
end

x0=(c*d-b*f)/(-detA);

y0=(a*f-b*d)/(-detA);

if b==0
  phi=0;
elseif c==a
  phi=pi/2;
else  
  phi=-0.5*acot((c-a)/(2*b));
end
  
if a==c
  la=sqrt( 2*(a*f^2+c*d^2+g*b^2-2*b*d*f-a*c*g)/(detA*(c+a)) );
  lb=la;
else
  tmp=(c-a)*sqrt(1+4*b^2/((a-c)^2));
  la=sqrt( 2*(a*f^2+c*d^2+g*b^2-2*b*d*f-a*c*g)/(detA*(tmp-(c+a))) );
  lb=sqrt( 2*(a*f^2+c*d^2+g*b^2-2*b*d*f-a*c*g)/(detA*(-tmp-(c+a))) );
end

la=abs(la);
lb=abs(lb);

p=[x0 y0 phi la lb]';
