function fig=showellipses(ellipses,im,fig,ellipsecolor,numbering,linewidth)

if nargin<3 | isempty(fig)
  fig=figure;
  imshow(im); hold on
else
  figure(fig); hold on
end
if nargin<4 | isempty(ellipsecolor)
  ellipsecolor='y';
end
if nargin<5 | isempty(numbering)
  numbering=1;
end
if nargin<5 | isempty(linewidth)
  linewidth=1;
end


n=size(ellipses,1);

for i=1:n
  u=ellipses(i,1); v=ellipses(i,2);
  a=ellipses(i,3); b=ellipses(i,4); c=ellipses(i,5);
  T=[1 0 -u; 0 1 -v; 0 0 1];
  C=T'*[a b 0; b c 0; 0 0 0]*T - [0 0 0; 0 0 0; 0 0 1];
  ellpar=conic2ellpar(C);
  [p,fig]=plotellipse(ellpar,fig,ellipsecolor,linewidth);
  if numbering
  text(u,v,num2str(i),'Color','m','BackgroundColor','y');
  end
end
