function [p,fig]=plotellipse(ellpar,fig,symb,linewidth)

if nargin<4 | isempty(linewidth)
  linewidth=1;
end

x0=ellpar(1); y0=ellpar(2);
phi=ellpar(3);
la=ellpar(4);
lb=ellpar(5);

%step=2*pi/(180);%2*pi/(2*360);
step=2*pi/(60);
t=0:step:(2*pi);

x=la*cos(t);
y=lb*sin(t);

R=[cos(phi) -sin(phi); sin(phi) cos(phi)];

p=R*[x;y]+[x0;y0]*ones(1,length(t));

if isempty(fig)
  return
else
  %figure(fig); hold on
  plot(p(1,:),p(2,:),symb,'LineWidth',linewidth);
end
