function mapexperiment_cvpr2007

im1name='imrph1.pgm';
im2name='imrph3.pgm';
im1=imread(im1name);
im2=imread(im2name);
im1d=double(im1)/255;
im2d=double(im2)/255;

load threeviewgeom;

load('cvpr_seeds_hesaff_1_3.mat'); 
startseed=19;

VIS=1;
if VIS
fig1=figure; colormap('gray'); imshow(im1);hold on
showellipses(ell{1}(startseed,:,1),im1,fig1,'y',0,3);
fig2=figure; colormap('gray'); imshow(im2);hold on
showellipses(ell{1}(startseed,:,2),im2,fig2,'y',0,3);
end


optso.N=3;optso.w=3;optso.z=0.8;optso.t=0.01;optso.e=1;optso.Fth=1;
opts.N=3;opts.w=3;opts.z=0.8;opts.t=0;opts.e=1;opts.Fth=1;

[maps_o,c_o,t_o]=matchpropagation_orig(im1d,im2d,seeds0{1}(startseed,1:4),optso);
[maps_oe,c_oe,t_oe]=matchpropagation_orig(im1d,im2d,seeds0{1}(startseed,1:4),optso,F31);

[maps_c,c_c,t_c]=matchpropagation_aff(im1d,im2d,seeds0{1}(startseed,:),opts,'const',F31);
[maps_e,c_e,t_e]=matchpropagation_aff(im1d,im2d,seeds0{1}(startseed,:),opts,'epip',F31);
[maps_au,c_au,t_au]=matchpropagation_aff(im1d,im2d,seeds0{1}(startseed,:),opts,'epipadapt',F31,[],'uniform');
[maps_ag,c_ag,t_ag]=matchpropagation_aff(im1d,im2d,seeds0{1}(startseed,:),opts,'epipadapt',F31,[],'gaussian');

[tmp,v_o]=checkmaps_twoplanes_cvpr(maps_o,K,Rs,ts);
[tmp,v_oe]=checkmaps_twoplanes_cvpr(maps_oe,K,Rs,ts);
[tmp,v_c]=checkmaps_twoplanes_cvpr(maps_c,K,Rs,ts);
[tmp,v_e]=checkmaps_twoplanes_cvpr(maps_e,K,Rs,ts);
[tmp,v_au]=checkmaps_twoplanes_cvpr(maps_au,K,Rs,ts);
[tmp,v_ag]=checkmaps_twoplanes_cvpr(maps_ag,K,Rs,ts);

save mapexperiment_cvpr2007
if VIS
  figure; colormap('gray');imagesc(v_o); colorbar
  figure; colormap('gray');imagesc(v_oe); colorbar
  figure; colormap('gray');imagesc(v_c); colorbar
  figure; colormap('gray');imagesc(v_e); colorbar
  figure; colormap('gray');imagesc(v_au); colorbar
  figure; colormap('gray');imagesc(v_ag); colorbar
end






