function [diffmap,vismap,NumOfMatches,Quartiles]=checkmaps_twoplanes_cvpr(map,K,Rs,ts)

%10.4
[H12,H13]=tablehomography(10.5,K,Rs,ts);
[Hc12,Hc13,origos,blines]=calibrationplanehomography(K,Rs,ts);
Ha=H13;Hb=Hc13;

VIS=0;
ia=2; ib=1;
origo=origos(:,3);
lines=blines(:,:,3);
%ia=1; ib=2;
if ia==1
  iHa=inv(Ha);
  iHb=inv(Hb); 
else
  iHa=Ha;
  Ha=inv(Ha);
  iHb=Hb;
  Hb=inv(Hb);
end

maps{1}=map{1};
[Mim(1),Nim(1)]=size(map{1});
maps{2}=map{2};
[Mim(2),Nim(2)]=size(map{2});

[ya,xa,va]=find(maps{ia});

NumOfMatches=length(va)
if NumOfMatches<1
  diffmap=[];vismap=[];
  return
end

xb=floor((va-1)/Mim(ib))+1;
yb=va-(xb-1)*Mim(ib);

signo=sign(origo'*lines);
pointsa=[xa ya ones(NumOfMatches,1)];
signs=sign(pointsa*lines);

signcheck=sum((signs==repmat(signo,NumOfMatches,1)),2);
indb=find(signcheck>=4);
inda=find(signcheck<4);

matches=[xa ya xb yb];
matchesa=matches(inda,:);
matchesb=matches(indb,:);

disp('Computing geometric errors');
%[res2sum,res2s,errvect]=homgeomerr(H,matches);
[deltasa,deltas2a]=hsampsondist(matchesa,Ha);
[deltasb,deltas2b]=hsampsondist(matchesb,Hb);
disp('Errors computed');
%[resg2sum,resg2s,resg]=hgeomdist(matches,H);
diffv=zeros(NumOfMatches,1);
diffv(inda)=sqrt(deltas2a(:)/2);
diffv(indb)=sqrt(deltas2b(:)/2);

MedianError=median(diffv)
MeanError=mean(diffv)
MaxError=max(diffv)
dvs=sort(diffv);
Quartiles=[dvs(1) dvs(floor(0.25*NumOfMatches)) dvs(floor(0.5*NumOfMatches))...
	   dvs(floor(0.75*NumOfMatches)) dvs(end)]

%keyboard
H=Ha;
iH=iHa;

diffmap=NaN*ones(Mim(ia),Nim(ia));
diffmap((xa-1)*Mim(ia)+ya)=diffv;

%if nargout<2
%  return
%end

%compute the common pixels in ia
centre=[(Nim(ia)+1)/2; (Mim(ia)+1)/2];
cb=[1 Nim(ib) Nim(ib) 1; 1 1 Mim(ib) Mim(ib)];
cba=iH*[cb; ones(1,4)]; %cba=cba(1:2,:)./cba([3 3],:);

%load images_and_Hs;
%cb=[1 Nim(ia) Nim(ia) 1; 1 1 Mim(ia) Mim(ia)];
%cba=H23s*[cb; ones(1,4)]; %cba=cba(1:2,:)./cba([3 3],:);

cp=[centre(:); 1];

la1=cross(cba(:,1),cba(:,2));
la2=cross(cba(:,2),cba(:,3));
la3=cross(cba(:,3),cba(:,4));
la4=cross(cba(:,4),cba(:,1));

[Xa,Ya]=meshgrid(1:Nim(ia),1:Mim(ia));
Npix=Nim(ia)*Mim(ia);
pa=[Xa(:) Ya(:)];
pap=[Xa(:) Ya(:) ones(Nim(ia)*Mim(ia),1)];

valid=(sign(pap*la1(:))==sign(la1(:)'*cp(:))) & ...
      (sign(pap*la2(:))==sign(la2(:)'*cp(:))) & ...
      (sign(pap*la3(:))==sign(la3(:)'*cp(:))) & ...
      (sign(pap*la4(:))==sign(la4(:)'*cp(:)));
pav=pa(valid,:);

pointspix=[pa ones(Npix,1)];
signs=sign(pointspix*lines);

signcheck=sum((signs==repmat(signo,Npix,1)),2);
indin=find(signcheck>=4);
pixinbh=Hb*(pointspix(indin,:))';
pixinb=(pixinbh(1:2,:)./pixinbh([3 3],:))';
inoutind=find(pixinb(:,1)<1 | pixinb(:,2)<1 | pixinb(:,1)>Nim(ib) | pixinb(:,2)>Mim(ib));
backgroundb=indin(inoutind);

commonareaval=7;
backgroundval=6;
vismap=(commonareaval*full(sparse(pav(:,2),pav(:,1),1,Mim(ia),Nim(ia))));

diffvis=diffv;
olind=find(diffvis>5);
diffvis(olind)=5;

background=find(vismap==0);
vismap(background)=backgroundval;
vismap(backgroundb)=backgroundval;

vismap((xa-1)*Mim(ia)+ya)=diffvis;

if VIS
figure; colormap('gray');imagesc(vismap); colorbar
end
%keyboard

%levels=[1 2 4];
%graylevels=[0 70 140 210];
%ili=find(diffv>=levels(end));
%vismap((xa(ili)-1)*Mim(ia)+ya(ili))=graylevels(end);
%for i=(length(levels):-1:1)
%  ili=find(diffv<levels(i));
%  vismap((xa(ili)-1)*Mim(ia)+ya(ili))=graylevels(i);
%end
%vismap=uint8(vismap);
%
%VIS=1;
%if VIS
%  figure; colormap('gray');
%  imshow(vismap);
%end
  
%keyboard
