function [Hc12,Hc13,origos,blines]=calibrationplanehomography(K,Rs,ts)

plane=[0 0 1 0]';
%n=plane(1:3);

R=Rs{1};t=ts{1};

%plane in canonical frame
H3D=[R t; zeros(1,3) 1];
pp=inv(H3D)'*plane;
pp=pp/pp(4);
v=pp(1:3);
n=v(:);

R2=Rs{2}*R';
t2=-R2*t+ts{2};

R3=Rs{3}*R';
t3=-R3*t+ts{3};

Ps{1}=K*[eye(3) zeros(3,1)];
Ps{2}=K*[R2 t2];
Ps{3}=K*[R3 t3];

iK=inv(K);
Hc12=K*(R2-t2*n')*iK;
Hc13=K*(R3-t3*n')*iK;

% points
O=[0 0 0 1]';
A=[-10 -10 0 1]';
B=[-10 15*15+15 0 1]';
C=[15*15+15 15*15+15 0 1]';
D=[15*15+15 -10 0 1]';

%points in canonical frame
Oc=H3D*O;
Ac=H3D*A;
Bc=H3D*B;
Cc=H3D*C;
Dc=H3D*D;

origos=[Ps{1}*Oc Ps{2}*Oc Ps{3}*Oc];

linea=linefrompoints(Ac,Bc);lineb=linefrompoints(Bc,Cc);
linec=linefrompoints(Cc,Dc);lined=linefrompoints(Dc,Ac);

la1=projectline(linea,Ps{1}); lb1=projectline(lineb,Ps{1});
lc1=projectline(linec,Ps{1}); ld1=projectline(lined,Ps{1});

la2=projectline(linea,Ps{2}); lb2=projectline(lineb,Ps{2});
lc2=projectline(linec,Ps{2}); ld2=projectline(lined,Ps{2});

la3=projectline(linea,Ps{3}); lb3=projectline(lineb,Ps{3});
lc3=projectline(linec,Ps{3}); ld3=projectline(lined,Ps{3});

blines=zeros(3,4,3);
blines(:,:,1)=[la1 lb1 lc1 ld1];
blines(:,:,2)=[la2 lb2 lc2 ld2];
blines(:,:,3)=[la3 lb3 lc3 ld3];
