function [newseeds,znccs]=znccseeds_orig(im1,im2,seeds,opts)
%
% sorts the seed matches according to the zncc measure 
%

% Copyright (C) Juho Kannala

if nargin<4 | isempty(opts)
  opts=matchingoptions;
end
N=opts.N;
e=opts.e;
t=opts.t;
z=opts.z;
w=opts.w;

n=size(seeds,1);
ims{1}=im1;
ims{2}=im2;
[Mim(1),Nim(1)]=size(im1);
[Mim(2),Nim(2)]=size(im2);
[Xim{1},Yim{1}]=meshgrid(1:Nim(1),1:Mim(1));
[Xim{2},Yim{2}]=meshgrid(1:Nim(2),1:Mim(2));
wlimits=-w:w;
Nw=w;

newseeds=zeros(size(seeds));


for i=1:n
  m=seeds(i,:);

  rm=round(m);
  if (rm(1)>(Nim(1)-Nw) | rm(1)<(Nw+1) | rm(2)>(Mim(1)-Nw) | rm(2)<(Nw+1) | ...
      rm(3)>(Nim(2)-Nw) | rm(3)<(Nw+1) | rm(4)>(Mim(2)-Nw) | rm(4)<(Nw+1))
    score(i)=NaN;
    continue;
  end

  win1=im1(wlimits+rm(2),wlimits+rm(1));
  win2=im2(wlimits+rm(4),wlimits+rm(3));

  score(i)=compcorrscore_fast(win1(:),win2(:));
end

[znccs,sind]=sort(score);
newseeds=seeds(sind,:);

