function [newseeds,znccs,sind]=znccaffseedssb_aff(im1,im2,seeds,opts)
%
% sorts the seeds
% 

% Copyright (C) Juho Kannala

if nargin<4 | isempty(opts)
  opts=matchingoptions;
end
N=opts.N;
e=opts.e;
t=opts.t;
z=opts.z;
w=opts.w;

ims{1}=im1; ims{2}=im2;
[Mim(1),Nim(1)]=size(im1);
[Mim(2),Nim(2)]=size(im2);
[Xim{1},Yim{1}]=meshgrid(1:Nim(1),1:Mim(1));
[Xim{2},Yim{2}]=meshgrid(1:Nim(2),1:Mim(2));
map{1}=zeros(Mim(1),Nim(1));
map{2}=zeros(Mim(2),Nim(2));

wlimits=-w:w;

limits=-N:N;
[nindi,nindj]=nhood(opts);
[X,Y]=meshgrid(limits,limits);
dpatch=2*N+1;
lpatch=(dpatch)^2;
Xpatch=X+(N+1);
Ypatch=Y+(N+1);

limitsbig=-(N+w):(N+w);
%[Xbig,Ybig]=meshgrid(limitsbig,limitsbig);
dbig=2*(N+w)+1;
%lbig=(dbig)^2;
%limb=(w+1):(w+dpatch);
Nw=N+w;

limitsbig_sb=-(N+w):0.5:(N+w);
odds=1:2:length(limitsbig_sb);
[Xbig_sb,Ybig_sb]=meshgrid(limitsbig_sb,limitsbig_sb);

uxo=Xpatch(nindi); uyo=Ypatch(nindi);
ubxo=uxo+w; ubyo=uyo+w;
bio=(ubxo-1)*dbig+ubyo;

upxo=Xpatch(nindj); upyo=Ypatch(nindj);
upbxo=upxo+w; upbyo=upyo+w;
bjo=(upbxo-1)*dbig+upbyo;



newseeds=zeros(size(seeds));

cind=find(Xpatch(nindi)==(N+1) & Ypatch(nindi)==(N+1) & ...
	  Xpatch(nindj)==(N+1) & Ypatch(nindj)==(N+1));
	  
if length(cind)~=1
  disp('In znccaffseeds: Something wrong');
end

n=size(seeds,1);

for i=1:n

  m=seeds(i,:);

  A=reshape(m(5:8),2,2);
  if isempty(A) | A==(zeros(2,2)) | isnan(A)
    continue;
  end
  detA=det(A);
  if abs(detA)<1
    xa=m(3); ya=m(4); xb=m(1); yb=m(2);
    ia=2; ib=1;
    iA=A;
    A=inv(A);
  else
    xa=m(1); ya=m(2); xb=m(3); yb=m(4);
    ia=1; ib=2;
    iA=inv(A);
  end

  [Xa,Ya,Xb,Yb,Xa_sb,Ya_sb,Xb_sb,Yb_sb]=wincoords_aff(Xbig_sb,Ybig_sb,odds,[xa;ya],[xb;yb],A);

  [wina,winb]=imwindows_aff(ims{ia},Xim{ia},Yim{ia},ims{ib},Xim{ib},Yim{ib},Xa_sb,Ya_sb,Xb_sb,Yb_sb,odds);

  win1=wina(wlimits+ubyo(cind),wlimits+ubxo(cind));
  win2=winb(wlimits+upbyo(cind),wlimits+upbxo(cind));

  score(i)=compcorrscore_fast(win1(:),win2(:));
end

[znccs,sind]=sort(score);
newseeds=seeds(sind,:);

%keyboard

function [nindi,nindj]=nhood(opts)

N=opts.N;
e=opts.e;

[X,Y]=meshgrid(1:(2*N+1),1:(2*N+1));
xv=X(:); yv=Y(:);
vlen=length(xv);

distmax=max(abs(repmat(xv,1,vlen)-repmat(xv',vlen,1)),abs(repmat(yv,1,vlen)-repmat(yv',vlen,1)));
[nindi,nindj]=find(distmax<=e);
