function [matchinds,dists]=siftmatchth(sift1,sift2,tha,thb)
%
% 
%

% Copyright (C) Juho Kannala


if nargin<3 | isempty(tha)
  tha=0.5;
end
if nargin<4 | isempty(thb)
  thb=1.05*tha;
end


n1=size(sift1,1);
dim=size(sift1,2);
n2=size(sift2,1);

dmat=zeros(n1,n2);

sift1n=sift1./repmat(sqrt(sum(sift1.^2,2)),1,dim);
sift2n=sift2./repmat(sqrt(sum(sift2.^2,2)),1,dim);

dmat=sqrt(repmat(sum(sift1n.^2,2),1,n2)+repmat((sum(sift2n.^2,2))',n1,1)-2*sift1n*sift2n');

%for i=1:n1
%  fprintf('%d/%d ',i,n1);
%  s1=sift1n(i,:);
%  di=sqrt(sum((sift2n-repmat(s1,n2,1)).^2,2));
%  dmat(i,:)=di';
%end

[mini,nn1]=min(dmat,[],2);
[mini,nn2]=min(dmat,[],1);

nomatch=[];
for i=1:n1
  [dni,ini]=sort(dmat(i,:));
  if nn2(nn1(i))~=i
    nomatch=[nomatch; i];
  elseif dni(1)>tha | dni(2)<thb%(1.5*dni(1))
    nomatch=[nomatch;i];
  end
    
  dnn(i)=dmat(i,nn1(i));
end

dtmp=dnn;
dtmp(nomatch)=[];
mtmp=[(1:n1)' nn1];
mtmp(nomatch,:)=[];

[dists,sind]=sort(dtmp);
matchinds=mtmp(sind,:);
