function [seeds,ell1,ell2]=seedregions(im1name,im2name)
% [seeds,ell1,ell2]=seedregions(im1name,im2name)
% 
% SEEDREGIONS computes the seed matches for match propagation 
%
% This works in Linux and requires the binaries "h_affine.ln" and "compute_descriptors.ln" from
% http://www.robots.ox.ac.uk/~vgg/research/affine/
% (implies that the image format must be pgm, ppm or png) 
% 
% INPUT:
%   im1name - the name of the first image file, for example 'im1.pgm'
%   im2name - the name of the second image file, for example 'im2.pgm'

% Copyright (C) Juho Kannala


%
% options
ftype='hesaff';
fromfile=0; %if 1 read descriptors from file
tha=0.5;  % thresholds for descriptor matching
thb=0.35
refine=0; %if refine=1 the position of matched elliptical regions is
          %iteratively refined (instead of using the detected
          %regions directly)


if nargin<4 | isempty(fromfile)
  fromfile=0;
end
if nargin<6 
  tha=[];thb=[];
end


filedetect1=strcat(im1name,'.',ftype);
filedetect2=strcat(im2name,'.',ftype);

filesifta1=strcat(im1name,'.',ftype,'.sifta');
filesiftb1=strcat(im1name,'.',ftype,'.siftb');
filesifta2=strcat(im2name,'.',ftype,'.sifta');
filesiftb2=strcat(im2name,'.',ftype,'.siftb');

if ~fromfile
disp('Images:');
fprintf(1,'%s %s \n',im1name,im2name);

sysdetect1=['h_affine.ln -i ',im1name,' -',ftype,' -o ',filedetect1];
sysdetect2=['h_affine.ln -i ',im2name,' -',ftype,' -o ',filedetect2];

system(sysdetect1);
system(sysdetect2);

disp('Affine regions extracted');

syssifta1=['compute_descriptors.ln -sift -i ',im1name,' -p1 ',filedetect1,' -o1 ',filesifta1];
syssiftb1=['compute_descriptors.ln -sift -i ',im1name,' -p1 ',filedetect1,' -o2 ',filesiftb1];

system(syssifta1);
system(syssiftb1);

syssifta2=['compute_descriptors.ln -sift -i ',im2name,' -p1 ',filedetect2,' -o1 ',filesifta2];
syssiftb2=['compute_descriptors.ln -sift -i ',im2name,' -p1 ',filedetect2,' -o2 ',filesiftb2];

system(syssifta2);
system(syssiftb2);


disp('Descriptors computed');

end

[feata1,nb1]=load_sifta(filesifta1);
[featb1]=load_siftb(filesiftb1);

[feata2,nb2]=load_sifta(filesifta2);
[featb2]=load_siftb(filesiftb2);

disp('Region data loaded');

for i=1:nb1
  ellipses1(i,:)=[feata1(1,i)+1 feata1(2,i)+1 feata1(3,i) feata1(4,i) feata1(5,i)];
  angles1(i)=featb1(5,i);	     
end
for i=1:nb2
  ellipses2(i,:)=[feata2(1,i)+1 feata2(2,i)+1 feata2(3,i) feata2(4,i) feata2(5,i)];
  angles2(i)=featb2(5,i);	     
end

sift1=feata1(6:end,:);
sift2=feata2(6:end,:);

disp('Matching descriptors ...');

[smatches,sdists]=siftmatchth(sift1',sift2',tha,thb);

disp('Descriptors matched');

alpha1=convertangles(ellipses1,angles1);
alpha2=convertangles(ellipses2,angles2);
alpha1=alpha1(:); alpha2=alpha2(:);

ind1=smatches(:,1);
ind2=smatches(:,2);
affseeds=[ellipses1(ind1,1:2) ellipses2(ind2,1:2) ellipses1(ind1,[3 4 4 5]) alpha1(ind1) ...
	 ellipses2(ind2,[3 4 4 5]) alpha2(ind2)];

%affseeds=flipud(affseeds);
%datafile=strcat('affinvseeds_',im1name,'_',im2name,'_',ftype,'.mat');
%save(datafile,'affseeds');

ell1=(ellipses1(ind1,:));
ell2=(ellipses2(ind2,:));
%keyboard

im1=double(imread(im1name));
im2=double(imread(im2name)); 

if length(size(im1))>2
  im1=rgb2gray(im1);
end
if length(size(im2))>2
  im2=rgb2gray(im2);
end

[seeds]=refineseeds(im1,im2,affseeds,refine);
