function [ea,eb]=orientedepipoles(F)
%
% computes the oriented epipoles from a fundamental matrix
%
% See:
%
% @Article{Chum03,
%   author =   "Chum, O. and Werner, T. and Pajdla, T.",
%   title =   "On joint orientation of epipoles",
%   journal =   "Research Report, CTU-CMP-2003-10, Czech Technical University",
%   year =   "2003",
% }


% Copyright (C) Juho Kannala


Ft=F';
[U,S,V]=svd(Ft);

eb=V(:,3);
eb=eb(:)/norm(eb);
v=vectofminors([F eb]);

ea=v(1:3);
ea=ea(:)/norm(ea);

check=1;
if check
  tol=10^(-10);
  na=norm(F*ea);
  nb=norm(F'*eb);
  if na<tol & nb<tol
  else
    warning('In orientedepipoles: Something wrong');
    disp('In orientedepipoles: Something wrong');
  end
end



function v=vectofminors(P)

id=1:4;
for i=1:4
  idi=id; idi(i)=[];
  v(i)=(-1)^i*det(P(:,idi));
end
