function [map,counter,timecounter]=matchpropagation_orig(im1,im2,seeds0,opts,F)
% [map,counter,timecounter]=matchpropagation_orig(im1,im2,seeds0,opts,F)
%
% MATCHPROPAGATION_ORIG computes quasi-dense pixel correspondences from
% a sparse set of initial matches
%
% INPUT:
%   im1,im2 - the images, the intensity values must be between 0 and 1
%   seeds0 - the seed matches, seeds0(i,:)=[x1 y1 x2 y2]
%   opts - the options for matchpropagation, see "matchingoptions.m"
% optional:
%   F - the fundamental matrix (for propagation with the epipolar constraint)
%
% OUTPUT:
%   map - the pixel correspondence maps so that map{1} corresponds
%         to im1 and map{2} corresponds to im2
%         (if map{1}(r,c) has a nonzero value v then the
%         corresponding pixel for pixel im1(r,c) is the pixel im2(v))
%   counter - the number of final pixel correspondences
%   timecounter - the propagation time
%
% For more information about the algorithm see the paper:
%  M. Lhuillier and L. Quan. "Match propagation for image-based
%  modeling and rendering", TPAMI, 24(8):1140-1146, 2002.
%

% Copyright (C) Juho Kannala



if nargin<4 | isempty(opts)
  opts=matchingoptions;
end
if nargin<5 | isempty(F)
  epipconstraint=0;
else
  epipconstraint=1;
end
N=opts.N;
e=opts.e;
t=opts.t;
z=opts.z;
w=opts.w;
Fth=opts.Fth;

[seeds0,znccs0]=znccseeds_orig(im1,im2,seeds0,opts);

[Mim(1),Nim(1)]=size(im1);
[Mim(2),Nim(2)]=size(im2);
map{1}=zeros(Mim(1),Nim(1));
map{2}=zeros(Mim(2),Nim(2));

wlimits=-w:w;

limits=-N:N;
[nindi,nindj]=nhood(opts);
[X,Y]=meshgrid(limits,limits);

seeds=zeros(max(Mim)*max(Nim),size(seeds0,2));
znccs=zeros(1,max(Mim)*max(Nim));
%seedsnext=zeros(max(Mim)*max(Nim),size(seeds0,2));
seedpointer=size(seeds0,1);
seeds(1:seedpointer,:)=round(seeds0);
znccs(1:seedpointer)=znccs0;

maxind=seedpointer;
counter=0;
tic;
while seedpointer>0
  local=[];
  localcc=[];

  m=seeds(maxind,:);%seeds(end,:);
  seeds(maxind,:)=seeds(seedpointer,:);
  znccs(maxind)=znccs(seedpointer);
  seedpointer=seedpointer-1;%seeds(end,:)=[];

  %if (rm(1)>(Nim(1)-Nw) || rm(1)<(Nw+1) || rm(2)>(Mim(1)-Nw) || rm(2)<(Nw+1) || ...
  %    rm(3)>(Nim(2)-Nw) || rm(3)<(Nw+1) || rm(4)>(Mim(2)-Nw) || rm(4)<(Nw+1))
  %  continue;
  %end
 
  NUx=X+m(1); NUy=Y+m(2);
  NUpx=X+m(3); NUpy=Y+m(4);
  
  ux=NUx(nindi); uy=NUy(nindi);
  upx=NUpx(nindj); upy=NUpy(nindj);
  bu=find(ux>(Nim(1)-w) | ux<(w+1) | uy>(Mim(1)-w) | uy<(w+1) | ...
	  upx>(Nim(2)-w) | upx<(w+1) | upy>(Mim(2)-w) | upy<(w+1) );
  ux(bu)=[]; uy(bu)=[]; upx(bu)=[]; upy(bu)=[];
  
  ux_p=ux+1;uy_p=uy+1;
  ux_m=ux-1;uy_m=uy-1;
  upx_p=upx+1;upy_p=upy+1;
  upx_m=upx-1;upy_m=upy-1;
  i1=(ux-1)*Mim(1)+uy;
  i2=(upx-1)*Mim(2)+upy;
  
  da=abs(im1((ux_p-1)*Mim(1)+uy)-im1(i1));
  db=abs(im1((ux_m-1)*Mim(1)+uy)-im1(i1));
  dc=abs(im1((ux-1)*Mim(1)+uy_p)-im1(i1));
  dd=abs(im1((ux-1)*Mim(1)+uy_m)-im1(i1));
 
  dpa=abs(im2((upx_p-1)*Mim(2)+upy)-im2(i2));
  dpb=abs(im2((upx_m-1)*Mim(2)+upy)-im2(i2));
  dpc=abs(im2((upx-1)*Mim(2)+upy_p)-im2(i2));
  dpd=abs(im2((upx-1)*Mim(2)+upy_m)-im2(i2));
    
  valid=(max([da(:) db(:) dc(:) dd(:)],[],2)>t & max([dpa(:) dpb(:) dpc(:) dpd(:)],[],2)>t);
  ux=ux(valid); uy=uy(valid); upx=upx(valid); upy=upy(valid);
  
  posa0=[ux uy];posb0=[upx upy];
  valid=(map{1}((posa0(:,1)-1)*Mim(1)+posa0(:,2))==0 & ...
          map{2}((posb0(:,1)-1)*Mim(2)+posb0(:,2))==0);
  ux=ux(valid); uy=uy(valid); upx=upx(valid); upy=upy(valid);
  
  if epipconstraint
    [fsd2]=fsampsondist2([ux uy upx upy],F);
    valid=find(fsd2<Fth);
    ux=ux(valid); uy=uy(valid); upx=upx(valid); upy=upy(valid);
  end
  
  nu=length(ux);
  for  i=1:nu
    win1=im1(wlimits+uy(i),wlimits+ux(i));
    win2=im2(wlimits+upy(i),wlimits+upx(i));
    si=compcorrscore_fast(win1(:),win2(:));
    if si>z
      local=[local; ux(i) uy(i) upx(i) upy(i)];
      localcc=[localcc; si];
    end
  end
  [scc,sind]=sort(localcc);
  localsort=local(sind,:);
  pointer=size(localsort,1);
  while pointer>0
    locals=localsort(pointer,:);
    scci=scc(pointer);
    if (map{1}(locals(2),locals(1))==0 & map{2}(locals(4),locals(3))==0)
      map{1}(locals(2),locals(1))=(locals(3)-1)*Mim(2)+locals(4);
      map{2}(locals(4),locals(3))=(locals(1)-1)*Mim(1)+locals(2);
      seedpointer=seedpointer+1;
      seeds(seedpointer,1:4)=locals;
      znccs(seedpointer)=scci;
      counter=counter+1;
    end
    pointer=pointer-1;
  end
  
  [maxval,maxind]=max(znccs(1:seedpointer));  
end

timecounter=toc;
%keyboard

function [nindi,nindj]=nhood(opts)

N=opts.N;
e=opts.e;

[X,Y]=meshgrid(1:(2*N+1),1:(2*N+1));
xv=X(:); yv=Y(:);
vlen=length(xv);

distmax=max(abs(repmat(xv,1,vlen)-repmat(xv',vlen,1)),abs(repmat(yv,1,vlen)-repmat(yv',vlen,1)));
[nindi,nindj]=find(distmax<=e);


