function [map,counter,timecounter,matchsb]=matchpropagation_aff(im1,im2,seeds0,opts,propagation,F,filsu,gfun)
% [map,counter,timecounter]=matchpropagation_aff(im1,im2,seeds0,opts,propagation,F,filsu,gfun)
%
% MATCHPROPAGATION_AFF computes quasi-dense pixel correspondences from
% a sparse set of initial matches using affine normalization
%
% INPUT:
%   im1,im2 - the images, the intensity values must be between 0 and 1
%   seeds0 - the seed matches, seeds0(i,:)=[x1 y1 x2 y2 A_11 A_21 A_12 A_22]
%   opts - the options for propagation, see "matchingoptions.m"
%   propagation - the mode of propagation: 'const','epip' or 'epipadapt'
% optional:
%   F - the fundamental matrix (for propagation with the epipolar constraint)
%   filsu - antialiasing filter for decimation, default [0.14 0.72 0.14]
%   gfun - windowing function: 'uniform' or 'gaussian' (default)
%
% OUTPUT:
%   map - the pixel correspondence maps so that map{1} corresponds
%         to im1 and map{2} corresponds to im2
%         (if map{1}(r,c) has a nonzero value v then the
%         corresponding pixel for pixel im1(r,c) is the pixel im2(v))
%   counter - the number of final pixel correspondences
%   timecounter - the propagation time
%   matchsb - the matches with sub-pixel level of accuracy, 
%             matchsb(i,:)=[x1 y1 x2 y2 A_11 A_21 A_12 A_22 znnc slabel] 
%
% For more information about the algorithm see the paper:
%  J. Kannala and S.S. Brandt. Quasi-dense wide baseline matching
%  using match propagation. CVPR 2007.
%

% Copyright (C) Juho Kannala


if nargin<4 | isempty(opts)
  opts=matchingoptions
end
N=opts.N;
e=opts.e;
t=opts.t;
z=opts.z;
w=opts.w;
Fth=opts.Fth;
%nangles=opts.nangles;
%nsectorwin=opts.nsectorwin;
[seeds0,znccs0,sortedids0]=znccaffseedssb_aff(im1,im2,seeds0,opts);

if nargin<6 | isempty(F)
  F=[];
end
if nargin<7 | isempty(filsu)
  filsu=[0.14 0.72 0.14];
end
if nargin<8 | isempty(gfun)
  gfun='';
end
H=[];

[Mim(1),Nim(1)]=size(im1);
[Mim(2),Nim(2)]=size(im2);
[Xim{1},Yim{1}]=meshgrid(1:Nim(1),1:Mim(1));
[Xim{2},Yim{2}]=meshgrid(1:Nim(2),1:Mim(2));
map{1}=zeros(Mim(1),Nim(1));
map{2}=zeros(Mim(2),Nim(2));

wlimits=-w:w;

limits=-N:N;
[nindi,nindj]=nhood(opts);
[X,Y]=meshgrid(limits,limits);
dpatch=2*N+1;
lpatch=(dpatch)^2;
Xpatch=X+(N+1);
Ypatch=Y+(N+1);

limitsbig=-(N+w):(N+w);
%[Xbig,Ybig]=meshgrid(limitsbig,limitsbig);
dbig=2*(N+w)+1;
%lbig=(dbig)^2;
%limb=(w+1):(w+dpatch);
Nw=N+w;

limitsbig_sb=-(N+w):0.5:(N+w);
odds=1:2:length(limitsbig_sb);
[Xbig_sb,Ybig_sb]=meshgrid(limitsbig_sb,limitsbig_sb);

uxo=Xpatch(nindi); uyo=Ypatch(nindi);
ubxo=uxo+w; ubyo=uyo+w;
bio=(ubxo-1)*dbig+ubyo;
   
upxo=Xpatch(nindj); upyo=Ypatch(nindj);
upbxo=upxo+w; upbyo=upyo+w;
bjo=(upbxo-1)*dbig+upbyo;

%[Xwd,Ywd,W,Wxx,Wxy,Wyy]=makemomwin(Covai);

switch gfun
 case {'uniform'}
  [Xw,Yw,W,Wxx,Wxy,Wyy]=makeuniformwindow(w);
 otherwise
  [Xw,Yw,W,Wxx,Wxy,Wyy]=makegaussianwindow(w);
end

switch propagation
 case {'epip','epipadapt','eadaptd'}
  if isempty(F)
    display(propagation);
    error('You must give the fundamental matrix in this propagation mode');
  end
  [ep1,ep2]=orientedepipoles(F);
  epipoles(:,1)=ep1; epipoles(:,2)=ep2;
end

ims{1}=im1; ims{2}=im2;

distA=0; distAnew=0;
counter=0;

%localcount=0;
Llocal=(2*N+1)^2;
localcc=zeros(Llocal,1); childindices=zeros(Llocal,1);
posa=zeros(Llocal,2); posb=zeros(Llocal,2); posasb=zeros(Llocal,2); posbsb=zeros(Llocal,2);
%posa=[]; posb=[];  posbsb=[];

seeds=zeros(max(Mim)*max(Nim),size(seeds0,2)+1);
matchsb=zeros(max(Mim)*max(Nim),size(seeds0,2)+2);
znccs=zeros(1,max(Mim)*max(Nim));
%seedsnext=zeros(max(Mim)*max(Nim),size(seeds0,2));
seedpointer=size(seeds0,1);
ids0=1:seedpointer;
seeds(ids0,:)=[seeds0 sortedids0(:)];
znccs(ids0)=znccs0;

iatable=zeros(max(Mim)*max(Nim),1);
ferrs=zeros(max(Mim)*max(Nim),1);
checkangles=0;

maxind=seedpointer;
tic;
while seedpointer>0 
  
  m=seeds(maxind,:);slabel=m(9);
  seeds(maxind,:)=seeds(seedpointer,:);
  znccs(maxind)=znccs(seedpointer);
  seedpointer=seedpointer-1;
 
  A=reshape(m(5:8),2,2);
  if isempty(A) | A==(zeros(2,2)) | isnan(A)
    continue;
  end
  detA=det(A);
  if abs(detA)<1
    xa=m(3); ya=m(4); xb=m(1); yb=m(2);
    ia=2; ib=1;
    iA=A;
    A=inv(A);
  else
    xa=m(1); ya=m(2); xb=m(3); yb=m(4);
    ia=1; ib=2;
    iA=inv(A);
  end
  
  [Xa,Ya,Xb,Yb,Xa_sb,Ya_sb,Xb_sb,Yb_sb]=wincoords_aff(Xbig_sb,Ybig_sb,odds,[xa;ya],[xb;yb],A);
 
  posa0sb=[Xa(bio) Ya(bio)];
  posb0sb=[Xb(bjo) Yb(bjo)];
  posa0=round(posa0sb);
  posb0=round(posb0sb);
  
  valid=(posb0(:,1)>1 & posb0(:,1)<Nim(ib)+1 & posb0(:,2)>1 & posb0(:,2)<Mim(ib)+1)...
	 & (posa0(:,1)>1 & posa0(:,1)<Nim(ia)+1 & posa0(:,2)>1 & posa0(:,2)<Mim(ia)+1);
  ubx=ubxo(valid); uby=ubyo(valid); upbx=upbxo(valid); upby=upbyo(valid);
  bi=bio(valid); bj=bjo(valid);
  posa0=posa0(valid,:);posb0=posb0(valid,:);
  posa0sb=posa0sb(valid,:);posb0sb=posb0sb(valid,:); 

  if isempty(bi)
    continue;
  end
  
  valid=(map{ia}((posa0(:,1)-1)*Mim(ia)+posa0(:,2))==0 & ...
	 map{ib}((posb0(:,1)-1)*Mim(ib)+posb0(:,2))==0);
  ubx=ubx(valid); uby=uby(valid); upbx=upbx(valid); upby=upby(valid);
  bi=bi(valid); bj=bj(valid);
  posa0=posa0(valid,:);posb0=posb0(valid,:);
  posa0sb=posa0sb(valid,:);posb0sb=posb0sb(valid,:); 
 
  switch propagation
   case {'epip','epipadapt','eadaptd'}
    %  if strcmp(propagation,'epip') | strcmp(propagation,'epipadapt')
    % take only candidates satisfying epipolar constraint 
    if ia==1
      matchi=[posa0sb posb0sb];
    else
      matchi=[posb0sb posa0sb];
    end
    [fsd2]=fsampsondist2(matchi,F);
    valid=find(fsd2<Fth);
    ubx=ubx(valid); uby=uby(valid); upbx=upbx(valid); upby=upby(valid);
    bi=bi(valid); bj=bj(valid);
    posa0=posa0(valid,:);posb0=posb0(valid,:);
    posa0sb=posa0sb(valid,:);posb0sb=posb0sb(valid,:); 
   otherwise
    
  end
  [wina,winb]=imwindows_aff(ims{ia},Xim{ia},Yim{ia},ims{ib},Xim{ib},Yim{ib},Xa_sb,Ya_sb,Xb_sb,Yb_sb,odds,filsu);

  localcount=0;
  nu=length(ubx);
  %keyboard
  for  i=1:nu
    win1=wina(wlimits+uby(i),wlimits+ubx(i));
    win2=winb(wlimits+upby(i),wlimits+upbx(i));
    [si,cdenomin]=compcorrscore_fast(win1(:),win2(:));
    if (si>z && cdenomin>t && ~isnan(si))
      localcount=localcount+1;	
      posa(localcount,:)=posa0(i,:);
      posb(localcount,:)=posb0(i,:);
      posasb(localcount,:)=posa0sb(i,:);	
      posbsb(localcount,:)=posb0sb(i,:);	
      localcc(localcount)=si;%[localcc; si];
      childindices(localcount)=i;
    end
  end
  [scc,sind]=sort(localcc(1:localcount));
  pointer=localcount;
  
  while pointer>0
    spind=sind(pointer);
    posai=posa(spind,:); posbi=posb(spind,:);
    posaisb=posasb(spind,:);posbisb=posbsb(spind,:);
    scci=scc(pointer);
    pointer=pointer-1;
    if (map{ia}(posai(2),posai(1))==0 && map{ib}(posbi(2),posbi(1))==0)
      map{ia}(posai(2),posai(1))=(posbi(1)-1)*Mim(ib)+posbi(2);
      map{ib}(posbi(2),posbi(1))=(posai(1)-1)*Mim(ia)+posai(2);
    else
      %keyboard
      continue;
    end
	
    switch propagation
     case {'const','epip'}
      Anew=A;
     case 'adapt' % obsolete
      disp('Obsolete propagation mode');
      [Sa,Sb]=intensmoms(ims{ia},ims{ib},posai(:),posbi(:),ga, ...
			 xxa,xya,yya,gb,xxb,xyb,yyb);
      if isempty(Sa) %| isempty(Sb)
	Anew=zeros(2,2);
      else
	Anew=afftfromsmom_fast(ims{ia},ims{ib},posai(:),posbisb(:),Sa,Sb,Wwc,Xwc,Ywc,bininds,angles,step);
      end
     case {'adaptd','eadaptd'}% just for testing with known directions % assume that H=F 
      disp('Obsolete propagation mode');
      if ia==1
	Ati=At; trans=tr; vti=vt;
      else
	Ati=iAt; trans=itr; vti=ivt;
      end
      Alocal=((1+vti*posai(:))*Ati-(Ati*posai(:)+trans)*vti)/((1+vti*posai(:))^2);
      %Alocal=Ati-(Ati*posai(:)+trans)*vti;
      anglea=0;tmp=Alocal*[1 0]';
      angleb=atan2(tmp(2),tmp(1));
      [Sa,Sb]=intensmoms(ims{ia},ims{ib},posai(:),posbi(:),ga,xxa,xya,yya,gb,xxb,xyb,yyb);
      if isempty(Sa) | isempty(Sb) | sum(isnan(Sa(:)))>0 | sum(isnan(Sb(:)))>0
	Anew=NaN*ones(2,2);
      else   
	Anew=afftfromregions(Sa,Sb,anglea,angleb,2);
      end
     case 'epipadapt'
      epa=epipoles(:,ia); epb=epipoles(:,ib);
      %la=cross(epa,[posai(:);1]);lb=-cross(epb,[posbisb(:);1]);
      la1=epa(2)-epa(3)*posaisb(2); la2=epa(3)*posaisb(1)-epa(1);
      %la1=epa(2)-epa(3)*posai(2); la2=epa(3)*posai(1)-epa(1);
      lb1=epb(3)*posbisb(2)-epb(2); lb2=epb(1)-epb(3)*posbisb(1);
      anglea=atan2(la1,-la2);angleb=atan2(lb1,-lb2);
      %anglea=atan2(la(1),-la(2));angleb=atan2(lb(1),-lb(2));
      %[Sa,Sb]=intensmomsaff(ims{ia},ims{ib},posaisb(:),posbisb(:),A,Xim{ib},Yim{ib},Xwd,Ywd,W,Wxx,Wxy,Wyy);
      win1=wina(wlimits+uby(childindices(spind)),wlimits+ubx(childindices(spind)));
      win2=winb(wlimits+upby(childindices(spind)),wlimits+upbx(childindices(spind)));
      [Sa,Sb]=winintensmom_aff(win1,win2,A,Xw,Yw,W,Wxx,Wxy,Wyy);
      if isempty(Sa) || isempty(Sb) || sum(isnan(Sa(:)))>0 || sum(isnan(Sb(:)))>0
	Anew=NaN*ones(2,2);
      else   
	Anew=afftfrommoms_aff(Sa,Sb,anglea,angleb,2);
 	%Anew=afftfromregions(Sa,Sb,anglea,angleb,2);
     end 
     otherwise
      %disp('Unknown propagation method, using default');
      Anew=A;
    end
      
    if ia==1
      posi12=[posaisb posbisb];
      Anew=Anew;
    else
      posi12=[posbisb posaisb];
      if ~isnan(Anew)
	Anew=inv(Anew);
      end
    end
    
    seedpointer=seedpointer+1;
    seeds(seedpointer,:)=[posi12 Anew(:)' slabel];
    znccs(seedpointer)=scci;

    counter=counter+1;
    matchsb(counter,:)=[posi12 Anew(:)' scci slabel];
    iatable(counter)=ia;
    %[fsdtmp,ferrs(counter)]=fsampsondist(posi12,F);
  end
  [maxval,maxind]=max(znccs(1:seedpointer));

end

timecounter=toc;
matchsb=matchsb(1:counter,:);
%keyboard

function [nindi,nindj]=nhood(opts)

N=opts.N;
e=opts.e;

[X,Y]=meshgrid(1:(2*N+1),1:(2*N+1));
xv=X(:); yv=Y(:);
vlen=length(xv);

distmax=max(abs(repmat(xv,1,vlen)-repmat(xv',vlen,1)),abs(repmat(yv,1,vlen)-repmat(yv',vlen,1)));
[nindi,nindj]=find(distmax<=e);

