function [err2]=fsampsondist2(matches,F)
%
% squared sampson distances from the fundamental matrix
%

% Copyright (C) Juho Kannala

n=size(matches,1);
onesn=ones(1,n);

x=matches(:,1:2);
xp=matches(:,3:4);

xh=[x'; onesn];
Fx=F*xh;
xph=[xp'; onesn];
Ftxp=F'*xph;

nomin=sum(xph.*Fx);
denomin=Fx(1,:).^2+Fx(2,:).^2+Ftxp(1,:).^2+Ftxp(2,:).^2;

%err=nomin./sqrt(denomin);

err2=(nomin.^2)./denomin;
