function [A]=afftfrommoms_aff(M1,M2,angle1,angle2,ttype)
%
% affine matrix A from im1 to im2
%
% angle1 and angle2 are corresponding directions in im1 and im2 
% (with respect to the x-axis) 
%
% assume M2=A*M1*A'
%
% if there is a conflict return empty
%
% see also: afftfromregions_fast.m

% Copyright (C) Juho Kannala

%errflag=0;
A=[];R=[];

[U1,D1]=eig(M1);
e1=diag(D1);pr1=prod(e1);
if det(U1)<0
  U1=[U1(:,1) -U1(:,2)];
end
[U2,D2]=eig(M2);
e2=diag(D2);pr2=prod(e2);
if det(U2)<0
  U2=[U2(:,1) -U2(:,2)];
end

if 0
%check singularity
if pr1==0 | pr2==0
  disp('In afftfrommoms:singular case');
  errflag=1;
  A=[]; return
end
%check signature
if sign(pr1)~=sign(pr2) | sign(max(e1))~=sign(max(e2))
  disp('In afftfrommoms:signatures dont match');
  errflag=2;
  A=[]; return
end
% indefinite case not implemented
end

if pr1<0 || pr2<0
  disp('In afftfrommoms:indefinite case');
  errflag=3;
  A=NaN*ones(2,2); return
end

sqrtabse2=sqrt(abs(e2));
sqrtabse1=sqrt(abs(e1));
oneper1=1./sqrtabse1;
oneper2=1./sqrtabse2;
T1=[oneper1 oneper1].*(U1');
T2=[oneper2 oneper2].*(U2');
iT2=U2.*[sqrtabse2'; sqrtabse2'];

%if nargin<4 | isempty(angle1) | isempty(angle2)
%  A=iT2*T1;
%  return
%end

d1=[cos(angle1);sin(angle1)];
d2=[cos(angle2);sin(angle2)];
dt1=T1*d1; dt1=dt1/norm(dt1);
dt2=T2*d2; dt2=dt2/norm(dt2);

cpk=(dt1(1)*dt2(2)-dt1(2)*dt2(1));
sinr=cpk;
cosr=dt1'*dt2;
%r=atan2(sinr,cosr);
R=[cosr -sinr; sinr cosr];
A=iT2*R*T1;

  
 


