function [A,posb,rmsf,rms0]=affinetemplatematching(ima,imb,A0,posb0,C,p)
%
% local mapping that maps ellipse C (at position p) from ima to imb is affine mapping A
% 
%

% Copyright (C) Juho Kannala


[ma,na]=size(ima);
[mb,nb]=size(imb);
[Xa,Ya]=meshgrid(1:na,1:ma);
[Xb,Yb]=meshgrid(1:nb,1:mb);

n=25;
d=2*n+1;
xp=-1:1/n:1;
yp=-1:1/n:1;
[Xw,Yw]=meshgrid(xp,yp);
sigma=0.5;%0.75; % or smaller
W=1/(2*pi*sigma^2)*exp(-0.5/sigma^2*(Xw.^2+Yw.^2));
weight=sqrt(W(:));

Ac=C^(-0.5);
pa=Ac*[Xw(:)';Yw(:)']+p*ones(1,d*d);
iwa=interp2(Xa,Ya,ima,reshape(pa(1,:),d,d),reshape(pa(2,:),d,d),'*linear');
iwa=(iwa-mean(iwa(:)))/std(iwa(:));
Ma=Ac;%[Ac p; 0 0 1];

av0=[A0(:); posb0];
v0=ssdcost(av0,iwa,imb,Xb,Yb,weight,Xw,Yw,Ma);
rms0=sqrt(mean((v0.^2)));

stop=0;
i=1;
optlsq0=optimset('lsqnonlin');
optlsq=optlsq0;
%optlsq=optimset(optlsq0,'LevenbergMarquardt','on');
while ~stop
  [avs(:,i),resnorm(i)]=lsqnonlin(@(av) ssdcost(av,iwa,imb,Xb,Yb,weight,Xw,Yw,Ma),av0,[],[],optlsq);
  av=avs(:,i);
  stop=1;
  %keyboard
  %i=i+1;
end

A=reshape(av(1:4),2,2);
posb=av(5:6);
vf=ssdcost(av,iwa,imb,Xb,Yb,weight,Xw,Yw,Ma);
rmsf=sqrt(mean((vf.^2)));


function v=ssdcost(av,iwa,imb,Xb,Yb,weight,Xw,Yw,Ma)

d=size(Xw,1);
%M=[reshape(av(1:4),2,2) av(5:6); 0 0 1];
%Mb=M*Ma;
%Aff=Mb(1:2,1:2); 
%t=Mb(1:2,3);
Aff=reshape(av(1:4),2,2)*Ma;
t=av(5:6);

%keyboard
pb=Aff*[Xw(:)';Yw(:)']+t*ones(1,d*d);
iwb=interp2(Xb,Yb,imb,reshape(pb(1,:),d,d),reshape(pb(2,:),d,d),'*linear');
iwb=(iwb-mean(iwb(:)))/std(iwb(:));

v=weight.*(iwa(:)-iwb(:));
%keyboard;
