function sys=calibconfig(name)

if strcmp(name,'watec_p23')
  sys.gui=0;
  sys.nameprefix='k';   
  sys.namesuffix='bmp';
  sys.numlen=2;
  sys.indexes=[11 12 13 14 15 16 17 18 20 21 22 23];
  sys.minidx=11;
  sys.maxidx=23;
  sys.blobcolor='white';   
  sys.blobradius=59.625;                             
  sys.blobgapx=160;
  sys.blobgapy=158;
  sys.grayscalew='gray';
  sys.circularimage='yes'; 
  sys.projtype='equidistance'; 
  sys.model='extended';  
  sys.focal=1.178;   
  sys.viewfield=180;  
  sys.pixelp=[];
  return;
end

if strcmp(name,'watec_p9')
  sys.gui=0;
  sys.nameprefix='k';   
  sys.namesuffix='bmp';
  sys.numlen=2;
  sys.indexes=[13 14 15 18];
  sys.minidx=13;
  sys.maxidx=18;
  sys.blobcolor='white';   
  sys.blobradius=59.625;                             
  sys.blobgapx=160;
  sys.blobgapy=158;
  sys.grayscalew='gray';
  sys.circularimage='yes'; 
  sys.projtype='equidistance'; 
  sys.model='radial';  
  sys.focal=1.178;   
  sys.viewfield=180;  
  sys.pixelp=[];
  return;
end

if strcmp(name,'watec_p6')
  sys.gui=0;
  sys.nameprefix='k';   
  sys.namesuffix='bmp';
  sys.numlen=2;
  sys.indexes=[11 12 13 14 15 16 17 18 20 21 22 23];
  sys.minidx=11;
  sys.maxidx=23;
  sys.blobcolor='white';   
  sys.blobradius=59.625;                             
  sys.blobgapx=160;
  sys.blobgapy=158;
  sys.grayscalew='gray';
  sys.circularimage='yes'; 
  sys.projtype='equidistance'; 
  sys.model='basic';  
  sys.focal=1.178;   
  sys.viewfield=180;  
  sys.pixelp=[];
  return;
end

if strcmp(name,'watec_p6star')
  sys.gui=0;
  sys.nameprefix='k';   
  sys.namesuffix='bmp';
  sys.numlen=2;
  sys.indexes=[11 12 13 14 15 16 17 18 20 21 22 23];
  sys.minidx=11;
  sys.maxidx=23;
  sys.blobcolor='white';   
  sys.blobradius=0;%59.625;                             
  sys.blobgapx=160;
  sys.blobgapy=158;
  sys.grayscalew='gray';
  sys.circularimage='yes'; 
  sys.projtype='equidistance'; 
  sys.model='basic';  
  sys.focal=1.178;   
  sys.viewfield=180;  
  sys.pixelp=[];
  return;
end


error('The requested setup data was not found. See calibconfig.m');
