function [ms,xs]=readdata(sys)
% [ms,xs]=readdata(sys)
%
% READDATA forms the data matrices for the camera calibration.
% Reads the data files made by CALIBDATA.
%
% input:
%   sys = the configuration structure initialised in calibconfig.m
% 
% output:
%   ms = cell array of two-column matrices, containing the measured
%        control point coordinates in each calibration image
%   xs = cell array of two-column matrices, containing the control
%        point coordinates in the calibration plane 
%
% See also CALIBCONFIG, CALIBDATA

% Copyright (C) 2004 Juho Kannala
%
% This software is distributed under the GNU General Public
% Licence (version 2 or later); please refer to the file
% Licence.txt, included with the software, for details.

[idxs,names, datafnames, cfnames]=makefilenames(sys);

N=size(names,1);

for i=1:N
  load(cfnames(i,:));
  ny=size(cmat,1);
  nx=size(cmat,2);
  mmat=cmat;
  mx=mmat(:,:,1); my=mmat(:,:,2);
  ms{i}=[mx(:) my(:)];
  Xmat=planecoords(nx,ny,sys.blobgapx,sys.blobgapy);
  xx=Xmat(:,:,1); xy=Xmat(:,:,2);
  xs{i}=[xx(:) xy(:)];
end
