function [pinit,thetamax]=initialiseinternalp(sys)
% [pinit,thetamax]=initialiseinternalp(sys)
%
% INITIALISEINTERNALP initialises the internal camera parameters.
%
% See also CALIBCONFIG

% Copyright (C) 2004 Juho Kannala
%
% This software is distributed under the GNU General Public
% Licence (version 2 or later); please refer to the file
% Licence.txt, included with the software, for details.

thetamax=sys.viewfield/2*pi/180;
theta=0:0.1/180*pi:thetamax;

if strcmp(sys.projtype,'perspective')
  persp=sys.focal*tan(theta);
  k=polyfitoddlsq(theta,persp,3);
  k1=k(3); k2=k(1);
elseif strcmp(sys.projtype,'stereographic')
  stereog=2*sys.focal*tan(theta/2);
  k=polyfitoddlsq(theta,stereog,3);
  k1=k(3); k2=k(1);
elseif strcmp(sys.projtype,'equidistance')
  equid=sys.focal*theta;
  k=polyfitoddlsq(theta,equid,3);
  k1=k(3); k2=k(1);
elseif strcmp(sys.projtype,'equisolidangle')
  equis=2*sys.focal*sin(theta/2);
  k=polyfitoddlsq(theta,equis,3);
  k1=k(3); k2=k(1);
elseif strcmp(sys.projtype,'orthographic')
  orthog=sys.focal*sin(theta);
  k=polyfitoddlsq(theta,orthog,3);
  k1=k(3); k2=k(1);
else
  error('In initialiseinternalp: Unknown projection type');
end

rmax=k1*thetamax+k2*thetamax^3;

if isempty(sys.pixelp)%strcmp(sys.circularimage,'yes')
  disp('In initialiseinternalp: sys.pixelp empty, loading ep.mat instead');
  load ep;
  mu=ep(1)/rmax; mv=ep(2)/rmax;
  u0=ep(3); v0=ep(4);
  pinit=[k1 k2 mu mv u0 v0];
else
  pinit=[k1 k2 sys.pixelp];
end

if length(pinit)~=6
  error('In initialiseinternalp: Initial guess for p failed. Check sys.pixelp and sys.circularimage in calibconfig.m');
end

