function [thetafirstmax, thetamax]=examineradialprojection(p)

% Copyright (C) 2004-2007 Juho Kannala
%
% This software is distributed under the GNU General Public
% Licence (version 2 or later); please refer to the file
% Licence.txt, included with the software, for details.



ts=[0:0.5:180]/180*pi;

if length(p)>=9
  k1=p(1); k2=p(2); k3=p(7); k4=p(8); k5=p(9);
  rc=[k5 0 k4 0 k3 0 k2 0 k1 0];
  dc=[9*k5 0 7*k4 0 5*k3 0 3*k2 0 k1];
else
  k1=p(1); k2=p(2);
  rc=[k2 0 k1 0];
  dc=[3*k2 0 k1];
end
  
rs=polyval(rc,ts);
ds=polyval(dc,ts);

[maxr,maxid]=max(rs);
thetamax=ts(maxid);

negderiv=find(ds<0);
thetafirstmax=ts(min(negderiv));

