function [Hs,err]=compHs(p,ms,xs,thetamax)

% Copyright (C) 2004-2005 Juho Kannala
%
% This software is distributed under the GNU General Public
% Licence (version 2 or later); please refer to the file
% Licence.txt, included with the software, for details.

N=length(ms);
A=[];
for i=1:N
  x=generic2sphere(ms{i},p,thetamax);
  xp=[xs{i} ones(size(xs{i},1),1)];
  H0=homdltps([xp x]);
  %options=optimset('LargeScale','off','LevenbergMarquardt','on', 'Display','iter','MaxFunEvals',10000);
  options=optimset('LargeScale','off','LevenbergMarquardt','on', 'Display','iter','MaxFunEvals',10000,'TolX',1e-4,'TolFun',1e-4);
  [H,resnorm,res]=lsqnonlin('homangleerr',H0,[],[],options,x,xp);
  err(i)=mean(abs(res));
  Hs{i}=H;
end

