#include <stdio.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <wait.h>
#include "ancillary.h"
#include "ipccommands.h"
#include "fdsclientlib.h"


void sillymessage(const int *hdr, int connection_fd)
{
	char buffer[256];
	int nbytes = read(connection_fd, buffer, 256);
	buffer[nbytes] = 0;

	printf("MESSAGE FROM CLIENT: %s\n", buffer);
	nbytes = sprintf(buffer, "hello from the server");
	int written = write(connection_fd, buffer, nbytes);
	assert(written == nbytes);
}

char *chroot(const int *hdr, int connection_fd)
{
	char *retval = (char*)malloc(hdr[2]+1);
	if (hdr[2] != read(connection_fd, retval, hdr[2]))
	{
		free(retval);
		return NULL;
	}
	retval[hdr[2]]='\0';
	return retval;
}

void fdsOpen(const int *hdr, int connection_fd, const char * root, int rootlen)
{
	if (NULL == root)
		exit(1);
	char *relfile = (char*)malloc(hdr[1]+1);
	if (hdr[1] != read(connection_fd, relfile, hdr[1]))
		exit(1);
	relfile[hdr[1]]='\0';

	int fulllen = hdr[1]+rootlen+1;
	char *fullpath=(char*)malloc(fulllen);

	strncpy(fullpath, root, fulllen);
	strncat(fullpath, relfile, fulllen);
	fullpath[fulllen]='\0';

	int readFd = open(fullpath, hdr[2], hdr[3]);
	int written = write (connection_fd, &readFd, sizeof(int));
	assert(written == sizeof(int));
	if(0 <= readFd)
	{
		ancil_send_fd(connection_fd, readFd);
		close(readFd);
	}

	free(fullpath);
	free(relfile);
}

int connection_handler(int connection_fd)
{
	char *root = NULL;
	int rootlen;
	int hdr[4];

	while(1){
		int nbytes = read(connection_fd, hdr, sizeof(hdr));
		assert (nbytes == sizeof(hdr));
		switch (hdr[0])
		{
			case FDS_QUIT:
				close(connection_fd);
				free(root);
				return 0;
				break;
			case FDS_CHROOT:
				root = chroot(hdr,connection_fd);
				rootlen=strlen(root);
				break;
			case FDS_OPEN:
				fdsOpen(hdr,connection_fd, root, rootlen);
				break;
			case FDS_SILLYMESSAGE:
				sillymessage(hdr,connection_fd);
				break;
		}

	}
	
	close(connection_fd);
	return 0;
}

int openSocket()
{
}

int main(void)
{
	struct sockaddr_un address;
	int socket_fd, connection_fd;
	size_t address_length;
	pid_t child;

	char *homedir = getenv("HOME");
	const char *sockrelpath = "/.local/fdsserver/socket";
	const char *logpath = "/.local/fdsserver/log.txt";

	int fulllen = strlen(homedir) + strlen(logpath);
	char *fullpath = (char*)malloc(fulllen+1);
	strncpy(fullpath, homedir, fulllen);
	strncat(fullpath, logpath, fulllen);
	fullpath[fulllen]='\0';

	int logfd=open(fullpath, O_CREAT | O_TRUNC, S_IRWXU);
	close(1);
	close(2);
	dup2(logfd,1);
	dup2(logfd,2);
	close(logfd);

	child=fork();
	if (child)
		return EXIT_SUCCESS;

	fulllen = strlen(homedir) + strlen(sockrelpath);
	fullpath = (char*)malloc(fulllen+1);
	strncpy(fullpath, homedir, fulllen);
	strncat(fullpath, sockrelpath, fulllen);
	fullpath[fulllen]='\0';
	
	socket_fd = socket(PF_UNIX, SOCK_STREAM, 0);
	if(socket_fd < 0)
	{
		printf("socket() failed\n");
		return 1;
	} 

	unlink(fullpath);
	address.sun_family = AF_UNIX;
	address_length = sizeof(address.sun_family) +
	                 sprintf(address.sun_path, "%s", fullpath);

	if(bind(socket_fd, (struct sockaddr *) &address, address_length) != 0)
	{
		printf("bind() failed\n");
		return 1;
	}

	if(listen(socket_fd, 5) != 0)
	{
		printf("listen() failed\n");
		return 1;
	}

	while((connection_fd = accept(socket_fd, NULL, NULL)) > -1)
	{
		child = fork();
		if(child == 0)
		{
			/* now inside newly created connection handling process */
			return connection_handler(connection_fd);
		}

		waitpid(-1, NULL, WNOHANG);
		/* still inside server process */
		close(connection_fd);
	}
	
	unlink(fullpath);
	close(1);
	close(2);
	close(socket_fd);
	return 0;
}

/*
int send_fd(int socket, int fd_to_send)
{
	struct msghdr message;
	struct iovec iov[1];
	struct cmsghdr *control_message = NULL;
	//char buffer[CMSG_SPACE(int)]
	char data[1];


	memset(&message, 9, sizeof(struct msghdr));
	//memset(buffer, CMSG_SPACE(int));

	data[0] = 'F';
	iov[0].iov_base = data;
	iov[0].iov_len = 1;

	message.msg_iov = iov;
	message.msg_iovlen = 1;

	control_message = CMSG_FIRSTHDR(&message);
	control_message->cmsg_level = SOL_SOCKET;
	control_message->cmsg_type = SCM_RIGHTS;
	control_message->cmsg_len= CMSG_LEN(sizeof(int));

	*((int *) CMSG_DATA(control_message)) = fd_to_send;

	message.msg_controllen = control_message->cmsg_len;

	return sendmsg(socket, &message, 0);
}
*/


