#include <stdio.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "ancillary.h"
#include "libsandbox.h"
#include "ipccommands.h"
#include "fdsclientlib.h"

extern "C" int FDS_connect(const char * fdsdaemonsocket)
{
	struct sockaddr_un address;
	int socket_fd;
	size_t address_length;
	char *env_FDS_SOCKET = NULL;

	if (env_FDS_SOCKET=getenv("FDS_SOCKET"))
			return atoi(env_FDS_SOCKET);

	socket_fd = socket(PF_UNIX, SOCK_STREAM, 0);
	if(socket_fd < 0)
	{
		return -2;
	}
	
	address.sun_family = AF_UNIX;
	address_length = sizeof(address.sun_family) +
		sprintf(address.sun_path, "%s", fdsdaemonsocket);

	if(connect(socket_fd, (struct sockaddr *) &address, address_length) != 0)
	{
		return -1;
	}
	return socket_fd;
}

extern "C" void FDS_disconnect(int socket_fd)
{
	int hdr[4] = {FDS_QUIT, 0, 0, 0};
	int written = write(socket_fd, hdr, sizeof(hdr));
	assert(sizeof(hdr) == written);
	close(socket_fd);
}

extern "C" int FDS_chroot(int socket_fd, const char * chrootdir)
{
	int hdr[4] = {FDS_CHROOT, 0, (int)strlen(chrootdir), 0}; //perhaps mask the flags
	int written = write(socket_fd, hdr, sizeof(hdr));
	if (sizeof(hdr) != written) return -1;
	written = write(socket_fd, chrootdir, hdr[2]);
	if (hdr[2] != written) return -1;
	if (getenv("FDS_NOCHROOT"))
		return 0;
	else
		return chrootme();
}

extern "C" int FDS_open(int socket_fd, const char * path, int flags, int mode)
{
	int a;
	int hdr[4] = {FDS_OPEN, (int)strlen(path), flags, mode}; //perhaps mask the flags
	if (sizeof(hdr) != write(socket_fd, hdr, sizeof(hdr)) )
		return WRITE_ERROR;
	if( hdr[1] != write(socket_fd, path, hdr[1]))
		return WRITE_ERROR;
	if (sizeof(int) != read(socket_fd, &a, sizeof(int)))
		return READ_ERROR;
	if (0 > a) return a;
	return ancil_recv_fd(socket_fd);
}


